/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ServerLogged;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@ServerLogged
@Provider
public class ServerLogginFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerLogginFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        log.info((Object)("Debin Server Request - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:" + new String(bytes, "UTF-8")));
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity != null) {
            log.info((Object)("Debin Server Response - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:" + new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity)));
        } else {
            log.info((Object)"Debin Server Response:(vacio)");
        }
    }
}

