package ar.com.sdd.commons.rest.core;

import javax.ws.rs.core.Response;

public class RestConnectorException extends Exception {

    private int status = -1;
    private Response.StatusType statusInfo;
    private Object entityError;

    public RestConnectorException(String message, int status, Response.StatusType statusInfo, Object entityError) {
        super(message);
        this.status = status;
        this.statusInfo = statusInfo;
        this.entityError = entityError;
    }

    public RestConnectorException(String message) {
        super(message);
    }

    public RestConnectorException(String message, Throwable cause) {
        super(message, cause);
    }

    public RestConnectorException(Throwable cause) {
        super(cause);
    }

    public RestConnectorException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public int getStatus() {
        return status;
    }

    public Response.StatusType getStatusInfo() {
        return statusInfo;
    }

    public Object getEntityError() {
        return entityError;
    }
}

