/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QueryBuilder {
    private String path = "";
    private StringBuilder params;
    private boolean firstParam = true;
    private SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");

    private QueryBuilder() {
        this.params = new StringBuilder();
    }

    public static QueryBuilder Builder() {
        return new QueryBuilder();
    }

    public QueryBuilder path(String path) {
        if (path != null) {
            this.path = path;
        }
        return this;
    }

    public QueryBuilder add(String key, String value) {
        if (key != null && value != null) {
            this.appendParam(key, value);
        }
        return this;
    }

    public QueryBuilder add(String key, Number value) {
        if (key != null && value != null) {
            this.appendParam(key, value.toString());
        }
        return this;
    }

    public QueryBuilder add(String key, Date value) {
        if (key != null && value != null) {
            this.appendParam(key, this.sdfDate.format(value));
        }
        return this;
    }

    public String build() {
        return this.path + this.params.toString();
    }

    private void appendParam(String key, String value) {
        if (this.firstParam) {
            this.params.append("?");
            this.firstParam = false;
        } else {
            this.params.append("&");
        }
        try {
            this.params.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("Encoding incorrecto en key [" + key + "], value [" + value + "]", e);
        }
    }
}

