package ar.com.sdd.commons.rest.util;

import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import javax.xml.bind.DatatypeConverter;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Serializa una fecha hacia el formato que usa Coelsa <br>
 * Ejemplo tomado de: https://kodejava.org/tag/jsondeserialize/ <br>
 * Ver notas en {@link ManyMillisecondsDateDeserializer#deserialize(JsonParser, DeserializationContext, Type)}}
 */
public class ManyMillisecondsDateSerializer implements JsonbSerializer<Date> {

    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializationContext ctx) {
        if (date != null) {
            Calendar cal = new GregorianCalendar();
            cal.setTime(date);
            jsonGenerator.write(DatatypeConverter.printDateTime(cal));
        }

    }
}

