/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ServerLogged;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@ServerLogged
@Provider
public class ServerLogginFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerLogginFilter.class);
    private static final Logger logAll = Logger.getLogger((String)"ar.com.sdd.commons.rest.log.LogAll");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        Object payload = new String(bytes, "UTF-8");
        String respuesta = "[" + RestConnectorUtil.getCacheSafeValue() + "]:[RestConnector] Server Request - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        logAll.trace((Object)(respuesta + (String)payload));
        if (((String)payload).length() > 8192) {
            payload = ((String)payload).substring(0, 8192) + "...more...";
        }
        log.info((Object)(respuesta + (String)payload));
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String respuesta = "[" + RestConnectorUtil.getCacheSafeValue() + "]:[RestConnector] Server Response - Method [" + requestContext.getMethod() + "], Status [" + responseContext.getStatus() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        Object entity = responseContext.getEntity();
        if (entity != null) {
            Object payload = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity);
            logAll.trace((Object)(respuesta + (String)payload));
            if (((String)payload).length() > 8192) {
                payload = ((String)payload).substring(0, 8192) + "...more...";
            }
            log.info((Object)(respuesta + (String)payload));
        } else {
            logAll.trace((Object)(respuesta + "(vacio)"));
            log.info((Object)(respuesta + "(vacio)"));
        }
    }
}

