package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErrorResult implements Serializable {

    public ErrorResult() {
    }

    public ErrorResult(String trackingCode, String description) {
        this.trackingCode = trackingCode;
        this.description = description;
    }

    private String trackingCode;
    private String description;

    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "ErrorResult ["
                + ((trackingCode != null) ? "trackingCode=" + trackingCode + ", " : "")
                + ((description != null) ? "description=" + description : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErrorResult that = (ErrorResult) o;

        if (trackingCode != null ? !trackingCode.equals(that.trackingCode) : that.trackingCode != null) return false;
        return description != null ? description.equals(that.description) : that.description == null;
    }

    @Override
    public int hashCode() {
        int result = trackingCode != null ? trackingCode.hashCode() : 0;
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }
}

