package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OAuth2Credential implements Serializable {

    @JsonProperty("client_id")
    private String clientId = null;

    @JsonProperty("client_secret")
    private String clientSecret = null;

    @JsonProperty("grant_type")
    private String grantType = "client_credentials";

    public OAuth2Credential() {

    }

    /**
     * Identificador del cliente (login name)
     **/
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * Clave del cliente (login password)
     **/
    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     * Tipo de acceso (siempre client_credentials)
     **/


    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Override
    public String toString() {
        return "OAuth2Credential ["
                + ((clientId != null) ? "clientId=" + clientId + ", " : "")
                + ((clientSecret != null) ? "clientSecret=" + clientSecret + ", " : "")
                + ((grantType != null) ? "grantType=" + grantType : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OAuth2Credential that = (OAuth2Credential) o;

        if (clientId != null ? !clientId.equals(that.clientId) : that.clientId != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
        return grantType != null ? grantType.equals(that.grantType) : that.grantType == null;
    }

    @Override
    public int hashCode() {
        int result = clientId != null ? clientId.hashCode() : 0;
        result = 31 * result + (clientSecret != null ? clientSecret.hashCode() : 0);
        result = 31 * result + (grantType != null ? grantType.hashCode() : 0);
        return result;
    }
}

