package ar.com.sdd.commons.rest.util;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;

public class RestConnectorUtil {

    public static final int MAX_ENTITY_SIZE = 1024 * 8;

    /**
     * El metodo retorna la current-time en milisegundos (en base 36).
     * @return
     */
    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, Character.MAX_RADIX);
    }

    public static File getLogFile(String timestamp36, String serverClientTag, String requestResponseTag, String tag) throws IOException {
        String date = DateFormatUtils.format(new Date(), "yyyyMMdd-HHmmss-SSS");
        String logFilename = "restconnector_" + serverClientTag + "_" + date + "_" + requestResponseTag + "_" + timestamp36 + ((tag != null) ? "_" + tag : "") + ".log";
        return new File(FilenameUtils.concat(getLogDirectory(), logFilename));
    }

    public static String getLogDirectory() throws IOException {
        String jbossLogDir = System.getProperty("jboss.server.log.dir");
        Path path = Paths.get(jbossLogDir, "io");
        File logDirectory = new File(path.toUri());
        if (!logDirectory.exists()) {
            boolean result = logDirectory.mkdirs();
            if (!result) {
                throw new IOException("No se pudo crear el directorio de log [" + logDirectory + "]");
            }
        }
        return logDirectory.getAbsolutePath();
    }

    public static String createTag(String method, String uri) {
        //Reemplazo caracteres raros en la uri
        uri = uri.replace("?", "_")
                .replace("&", "_")
                .replace("//", "")
                .replace("https", "")
                .replace("http", "")
                .replace(":", "")
                .replace("=", "_")
                .replace("/", "_")
                .replace(".", "_")
                .replace(",", "_")
                .replace("__", "_");
        return method + "_" + uri;
    }

}
