/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class RestConnectorUtil {
    public static final int MAX_ENTITY_SIZE = 8192;
    public static final int MAX_FILENAME_NO_EXT_SIZE = 251;

    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, 36);
    }

    public static File getLogFile(String timestamp36, String serverClientTag, String requestResponseTag, String tag) throws IOException {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd-HHmmss-SSS");
        Object logFilenameNoExt = "restconnector_" + serverClientTag + "_" + date + "_" + requestResponseTag + "_" + timestamp36 + (String)(tag != null ? "_" + tag : "");
        if (((String)logFilenameNoExt).length() > 251) {
            logFilenameNoExt = ((String)logFilenameNoExt).substring(0, 251);
        }
        return new File(FilenameUtils.concat((String)RestConnectorUtil.getLogDirectory(), (String)((String)logFilenameNoExt + ".log")));
    }

    private static String getLogDirectory() throws IOException {
        boolean result;
        String jbossLogDir = System.getProperty("jboss.server.log.dir");
        Path path = Paths.get(jbossLogDir, "io");
        File logDirectory = new File(path.toUri());
        if (!logDirectory.exists() && !(result = logDirectory.mkdirs())) {
            throw new IOException("No se pudo crear el directorio de log [" + logDirectory + "]");
        }
        return logDirectory.getAbsolutePath();
    }

    public static String createTag(String method, String uri) {
        uri = uri.replace("?", "_").replace("&", "_").replace("//", "").replace("https", "").replace("http", "").replace(":", "").replace("=", "_").replace("/", "_").replace(".", "_").replace(",", "_").replace("__", "_");
        return method + "_" + uri;
    }
}

