/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.log4j.Logger;

@Priority(value=-2147483648)
public class ClientLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final Logger log = Logger.getLogger(ClientLoggingFilter.class);
    private static final String ENTITY_STREAM_PROPERTY = "ClientLoggingFilter.entityStream";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final int maxEntitySize = 8192;

    private void log(StringBuilder sb) {
        log.info((Object)sb.toString());
    }

    private InputStream logInboundEntity(StringBuilder sb, Response.StatusType statusInfo, InputStream stream, Charset charset) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(8193);
        byte[] entity = new byte[8193];
        int entitySize = stream.read(entity);
        sb.append("[RestConnector] Client Response - Status [" + statusInfo.getStatusCode() + "]:");
        sb.append(new String(entity, 0, Math.min(entitySize, 8192), charset));
        if (entitySize > 8192) {
            sb.append("...more...");
        }
        stream.reset();
        return stream;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(requestContext.getEntityStream(), requestContext.getUri());
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (responseContext.hasEntity()) {
            responseContext.setEntityStream(this.logInboundEntity(sb, responseContext.getStatusInfo(), responseContext.getEntityStream(), DEFAULT_CHARSET));
            this.log(sb);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream != null) {
            this.log(stream.getStringBuilder(DEFAULT_CHARSET));
        }
    }

    private class LoggingStream
    extends FilterOutputStream {
        private final StringBuilder sb;
        private final ByteArrayOutputStream baos;
        private URI uri;

        LoggingStream(OutputStream out, URI uri) {
            super(out);
            this.sb = new StringBuilder();
            this.baos = new ByteArrayOutputStream();
            this.uri = uri;
        }

        StringBuilder getStringBuilder(Charset charset) {
            byte[] entity = this.baos.toByteArray();
            this.sb.append("[RestConnector] Client Request - URI [" + this.uri + "]:");
            this.sb.append(new String(entity, 0, entity.length, charset));
            if (entity.length > 8192) {
                this.sb.append("...more...");
            }
            return this.sb;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.baos.size() <= 8192) {
                this.baos.write(i);
            }
            this.out.write(i);
        }
    }
}

