/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Priority(value=-2147483648)
public class ClientFileLoggingFilter
implements ClientLoggingFilter {
    private static final Logger log = Logger.getLogger(ClientFileLoggingFilter.class);
    private static final String ENTITY_STREAM_PROPERTY = "ClientLoggingFilter.entityStream";

    public void filter(ClientRequestContext requestContext) {
        String timestamp36 = RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", (Object)timestamp36);
        String method = requestContext.getMethod() != null ? requestContext.getMethod() : "N/A";
        String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "N/A";
        String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
        String respuesta = "[" + timestamp36 + "]:[RestConnector] Client Request - Method [" + method + "], Headers [" + headers + "], URI [" + uri + "]";
        if (requestContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(requestContext.getEntityStream(), timestamp36, respuesta, method, uri);
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        } else {
            log.info((Object)(respuesta + "(vacio)"));
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream != null) {
            stream.logStream();
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        String timestamp36 = (String)requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty((CharSequence)timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn((Object)("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]"));
        }
        String statusCode = responseContext.getStatusInfo() != null ? String.valueOf(responseContext.getStatusInfo().getStatusCode()) : "N/A";
        String method = requestContext.getMethod();
        String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "";
        String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
        String respuesta = "[" + timestamp36 + "]:[RestConnector] Client Response - Method [" + method + "], Status [" + statusCode + "], Headers [" + headers + "], URI [" + uri + "]";
        boolean chunked = responseContext.getHeaders() != null && responseContext.getHeaderString("Transfer-Encoding") != null && responseContext.getHeaderString("Transfer-Encoding").equalsIgnoreCase("chunked");
        File logFile = RestConnectorUtil.getLogFile(timestamp36, "client", "response", RestConnectorUtil.createTag(method, uri));
        log.info((Object)(respuesta + ", logFile [" + logFile + "]"));
        String entityStreamResult = null;
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(logFile));){
            bos.write((respuesta + "\n").getBytes(StandardCharsets.UTF_8));
            if (responseContext.hasEntity() && !chunked) {
                entityStreamResult = IOUtils.toString((InputStream)responseContext.getEntityStream(), (Charset)StandardCharsets.UTF_8);
                bos.write(entityStreamResult.getBytes(StandardCharsets.UTF_8));
            } else if (chunked) {
                bos.write("(chunked)".getBytes(StandardCharsets.UTF_8));
            } else {
                bos.write("(vacio)".getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            log.error((Object)("[" + timestamp36 + "] No se pudo escribir el archivo de log [" + logFile + "]"), (Throwable)e);
        }
        if (responseContext.hasEntity() && !chunked && entityStreamResult != null) {
            responseContext.setEntityStream(IOUtils.toInputStream(entityStreamResult, (Charset)StandardCharsets.UTF_8));
        }
    }

    private static class LoggingStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final String timestamp36;
        private final String respuesta;
        private final String method;
        private final String uri;

        LoggingStream(OutputStream out, String timestamp36, String respuesta, String method, String uri) {
            super(out);
            this.timestamp36 = timestamp36;
            this.respuesta = respuesta;
            this.method = method;
            this.uri = uri;
        }

        void logStream() throws IOException {
            File logFile = RestConnectorUtil.getLogFile(this.timestamp36, "client", "request", RestConnectorUtil.createTag(this.method, this.uri));
            log.info((Object)(this.respuesta + ", logFile [" + logFile + "]"));
            byte[] bytes = this.baos.toByteArray();
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(logFile));){
                bos.write((this.respuesta + "\n").getBytes(StandardCharsets.UTF_8));
                bos.write(bytes);
            }
            catch (Exception e) {
                log.error((Object)("[" + this.timestamp36 + "] No se pudo escribir el archivo de log [" + logFile + "]"), (Throwable)e);
            }
        }

        @Override
        public void write(int i) throws IOException {
            this.baos.write(i);
            this.out.write(i);
        }
    }
}

