/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.log.ClientFileLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggerLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RestConnector {
    private static final Logger log = Logger.getLogger(RestConnector.class);
    private RestConnectorEnvironment environment;
    private RestSecurityManager securityManager;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private boolean useKeyStoreWithEmbeddedTrustStore;
    private ClientLoggingFilter clientLoggingFilter;

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager) {
        this(environment, securityManager, true);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile) {
        this(environment, securityManager, true, false);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile, boolean useKeyStoreWithEmbeddedTrustStore) {
        this.environment = environment;
        this.securityManager = securityManager;
        if (!StringUtils.isEmpty((CharSequence)environment.keyStorePath)) {
            try {
                this.keyStore = this.loadStore(environment.keyStorePath, environment.keyStorePassword);
            }
            catch (Exception e) {
                log.error((Object)("No se pudo cargar el keystore de [" + environment.keyStorePath + "] con password [" + environment.keyStorePassword + "]"), (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)environment.trustStorePath)) {
            try {
                this.trustStore = this.loadStore(environment.trustStorePath, environment.trustStorePassword);
            }
            catch (Exception e) {
                log.error((Object)("No se pudo cargar el trustStore de [" + environment.trustStorePath + "] con password [" + environment.trustStorePassword + "]"), (Throwable)e);
            }
        }
        if (useKeyStoreWithEmbeddedTrustStore) {
            log.debug((Object)("Usando el keyStore [" + environment.keyStorePath + "] como trustStore"));
            this.trustStore = this.keyStore;
        }
        this.clientLoggingFilter = logClientToFile ? new ClientFileLoggingFilter() : new ClientLoggerLoggingFilter();
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, null, path, (Map<String, Object>)null);
    }

    public <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, errorType, path, null);
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, String templateKey, String templateValue) throws RestConnectorException {
        return this.genericGet(request, responseType, null, path, templateKey, templateValue);
    }

    public <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return this.genericGet(request, responseType, errorType, path, templateParameters);
    }

    private <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Get cliente request [" + request + "]"));
        try (Response getResponse = null;){
            getResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).get();
            log.trace((Object)("[RestConnector] Get cliente response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]"));
            this.checkSuccessfulOrException(getResponse, errorType);
            Res Res = this.processResponse(getResponse, responseType);
            return Res;
        }
    }

    public <Req, Err> String genericGetTextResponse(Req request, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Get cliente request [" + request + "] con text response"));
        try (Response getResponse = null;){
            getResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"text/plain"}).get();
            log.trace((Object)("[RestConnector] Get cliente text response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]"));
            this.checkSuccessfulOrException(getResponse, errorType);
            String string = this.processResponse(getResponse, String.class);
            return string;
        }
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericPost(request, responseType, path, "application/json", "application/json");
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPost(request, responseType, null, path, acceptMediaType, postMediaType);
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericPost(request, responseType, errorType, path, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Post cliente request [" + request + "]"));
        try (Response postResponse = null;){
            postResponse = this.buildRequest(this.environment.baseUrl + path, null).accept(new String[]{acceptMediaType}).post(Entity.entity(request, (String)postMediaType));
            log.trace((Object)("[RestConnector] Post cliente response [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]"));
            this.checkSuccessfulOrException(postResponse, errorType);
            Res Res = this.processResponse(postResponse, responseType);
            return Res;
        }
    }

    public <Res, Req> Res genericPut(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericPut(request, responseType, null, path, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericPut(request, responseType, errorType, path, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPut(request, responseType, errorType, path, acceptMediaType, postMediaType, null);
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Put cliente request [" + request + "]"));
        try (Response putResponse = null;){
            putResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{acceptMediaType}).put(Entity.entity(request, (String)postMediaType));
            log.trace((Object)("[RestConnector] Put cliente response [" + putResponse.getStatus() + "/" + putResponse.getStatusInfo() + "]"));
            this.checkSuccessfulOrException(putResponse, errorType);
            Res Res = this.processResponse(putResponse, responseType);
            return Res;
        }
    }

    public <Res, Req> Res genericDelete(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericDelete(request, responseType, null, path, templateParameters);
    }

    public <Res, Req, Err> Res genericDelete(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        log.trace((Object)("[RestConnector] Delete cliente request [" + request + "]"));
        try (Response deleteResponse = null;){
            deleteResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).delete();
            log.trace((Object)("[RestConnector] Delete cliente response [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]"));
            this.checkSuccessfulOrException(deleteResponse, errorType);
            Object entityResponse = deleteResponse.readEntity(responseType);
            log.trace((Object)("[RestConnector] Entity response [" + entityResponse + "]"));
            Object object = entityResponse;
            return (Res)object;
        }
    }

    private <Err> void checkSuccessfulOrException(Response response, Class<Err> errorType) throws RestConnectorException {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Object entityResponseError = null;
            if (errorType != null) {
                entityResponseError = response.readEntity(errorType);
            }
            throw new RestConnectorException("La consulta no devolvio OK. Status: [" + response.getStatus() + "/" + response.getStatusInfo() + "]", response.getStatus(), response.getStatusInfo(), entityResponseError);
        }
    }

    private <Res> Res processResponse(Response response, Class<Res> responseType) {
        Object entityResponse;
        if (response.getEntity() == null || responseType == Void.class) {
            entityResponse = null;
            log.trace((Object)"[RestConnector] Entity response [vacio]");
        } else {
            entityResponse = response.readEntity(responseType);
            log.trace((Object)("[RestConnector] Entity response [" + entityResponse + "]"));
        }
        return (Res)entityResponse;
    }

    public Invocation.Builder buildRequest(String url, Map<String, Object> templateParameters) throws RestConnectorException {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.keyStore != null) {
            builder.keyStore(this.keyStore, this.environment.keyStorePassword);
        }
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        WebTarget resource = builder.build().target(url);
        resource.register((Object)this.clientLoggingFilter);
        if (templateParameters != null) {
            resource = resource.resolveTemplates(templateParameters);
        }
        Invocation.Builder request = resource.request();
        if (this.securityManager != null) {
            request = this.securityManager.addHeaders(request);
        }
        return request;
    }

    private KeyStore loadStore(String storePath, String storePassword) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(new FileInputStream(storePath), storePassword.toCharArray());
        return store;
    }
}

