package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SsoCredential implements Serializable {

    private String actionUrl;
    private Integer expiresIn;

    public String getActionUrl() {
        return actionUrl;
    }

    public void setActionUrl(String actionUrl) {
        this.actionUrl = actionUrl;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "SsoCredential ["
                + ((actionUrl != null) ? "actionUrl=" + actionUrl + ", " : "")
                + ((expiresIn != null) ? "expiresIn=" + expiresIn : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SsoCredential that = (SsoCredential) o;

        if (actionUrl != null ? !actionUrl.equals(that.actionUrl) : that.actionUrl != null) return false;
        return expiresIn != null ? expiresIn.equals(that.expiresIn) : that.expiresIn == null;
    }

    @Override
    public int hashCode() {
        int result = actionUrl != null ? actionUrl.hashCode() : 0;
        result = 31 * result + (expiresIn != null ? expiresIn.hashCode() : 0);
        return result;
    }
}
