/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.QueueLogHolderByteArray;
import ar.com.sdd.commons.rest.log.QueuedLogWriter;
import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ServerFileLogged
@Provider
public class ServerFileLogginFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerFileLogginFilter.class);
    private static QueuedLogWriter queuedLogWriterInstance;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)baos);
        String timestamp36 = RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", (Object)timestamp36);
        String method = requestContext.getMethod();
        String uri = requestContext.getUriInfo().getRequestUri() != null ? requestContext.getUriInfo().getRequestUri().toString() : "";
        String headers = RestConnectorUtil.getHeadersStringString((MultivaluedMap<String, String>)requestContext.getHeaders());
        String date = RestConnectorUtil.getFormattedDate(new Date());
        String respuesta = "[" + date + "][" + timestamp36 + "]:[RestConnector] serreq - Method [" + method + "], Headers [" + headers + "], URI [" + uri + "]";
        File logFile = RestConnectorUtil.getLogFile(date, timestamp36, "ser", "req", RestConnectorUtil.createTag(method, uri));
        log.info((Object)(respuesta + ", logFile [" + logFile + "]"));
        byte[] bytes = baos.toByteArray();
        queuedLogWriterInstance.add(new QueueLogHolderByteArray(bytes, logFile.getAbsolutePath(), respuesta, timestamp36));
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity;
        String timestamp36 = (String)requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty((CharSequence)timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn((Object)("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]"));
        }
        String method = requestContext.getMethod();
        String uri = requestContext.getUriInfo().getRequestUri() != null ? requestContext.getUriInfo().getRequestUri().toString() : "";
        String headers = RestConnectorUtil.getHeadersStringString((MultivaluedMap<String, String>)requestContext.getHeaders());
        String date = RestConnectorUtil.getFormattedDate(new Date());
        String respuesta = "[" + date + "][" + timestamp36 + "]:[RestConnector] serres - Method [" + method + "], Status [" + responseContext.getStatus() + "], Headers [" + headers + "], URI [" + uri + "]";
        String bearer = (String)requestContext.getProperty("bearer");
        if (!StringUtils.isEmpty((CharSequence)bearer)) {
            respuesta = respuesta + ", Bearer [" + bearer + "]";
        }
        if ((entity = responseContext.getEntity()) != null) {
            File logFile = RestConnectorUtil.getLogFile(date, timestamp36, "ser", "res", RestConnectorUtil.createTag(method, uri));
            log.info((Object)(respuesta + ", logFile [" + logFile + "]"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintWriter baosWriter = new PrintWriter(new ByteArrayOutputStream());){
                baosWriter.write(respuesta + "\n");
                new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)baosWriter, entity);
            }
            catch (Exception e) {
                log.error((Object)("[" + timestamp36 + "] No se pudo escribir el baos"), (Throwable)e);
            }
            byte[] bytes = baos.toByteArray();
            queuedLogWriterInstance.add(new QueueLogHolderByteArray(bytes, logFile.getAbsolutePath(), respuesta, timestamp36));
        } else {
            log.info((Object)(respuesta + "(vacio)"));
        }
    }

    public static void setQueuedLogWriterInstance(QueuedLogWriter queuedLogWriterInstance) {
        ServerFileLogginFilter.queuedLogWriterInstance = queuedLogWriterInstance;
    }
}

