/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ServerLogged;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ServerLogged
@Provider
public class ServerLogginFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LogManager.getLogger(ServerLogginFilter.class);
    private static final Logger logAll = LogManager.getLogger((String)"ar.com.sdd.commons.rest.log.LogAll");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        Object payload = new String(bytes, StandardCharsets.UTF_8);
        String headers = RestConnectorUtil.getHeadersStringString((MultivaluedMap<String, String>)requestContext.getHeaders());
        String respuesta = "[" + RestConnectorUtil.getCacheSafeValue() + "]:[RestConnector] serreq - Method [" + requestContext.getMethod() + "], Headers [" + headers + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        logAll.trace(respuesta + (String)payload);
        if (((String)payload).length() > 8192) {
            payload = ((String)payload).substring(0, 8192) + "...more...";
        }
        log.info(respuesta + (String)payload);
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String headers = RestConnectorUtil.getHeadersStringString((MultivaluedMap<String, String>)requestContext.getHeaders());
        String respuesta = "[" + RestConnectorUtil.getCacheSafeValue() + "]:[RestConnector] serres - Method [" + requestContext.getMethod() + "], Status [" + responseContext.getStatus() + "], Headers [" + headers + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:";
        Object entity = responseContext.getEntity();
        if (entity != null) {
            Object payload = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity);
            logAll.trace(respuesta + (String)payload);
            if (((String)payload).length() > 8192) {
                payload = ((String)payload).substring(0, 8192) + "...more...";
            }
            log.info(respuesta + (String)payload);
        } else {
            logAll.trace(respuesta + "(vacio)");
            log.info(respuesta + "(vacio)");
        }
    }
}

