/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import ar.com.sdd.commons.rest.log.QueueLogHolderByteArray;
import ar.com.sdd.commons.rest.log.QueuedLogWriter;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Priority(value=-2147483648)
public class ClientFileLoggingFilter
implements ClientLoggingFilter {
    private static final Logger log = LogManager.getLogger(ClientFileLoggingFilter.class);
    private static QueuedLogWriter queuedLogWriterInstance;
    private static final String ENTITY_STREAM_PROPERTY = "ClientLoggingFilter.entityStream";

    public void filter(ClientRequestContext requestContext) {
        String timestamp36 = RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", (Object)timestamp36);
        String method = requestContext.getMethod() != null ? requestContext.getMethod() : "N/A";
        String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "N/A";
        String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
        String date = RestConnectorUtil.getFormattedDate(new Date());
        StringBuilder respuesta = new StringBuilder();
        respuesta.append("[").append(timestamp36).append("]:[RestConnector.clireq][").append(method).append("],H=[").append(headers).append("],URI=[").append(uri).append("]");
        if (requestContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(requestContext.getEntityStream(), date, timestamp36, respuesta.toString(), method, uri);
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        } else {
            log.info(respuesta + "(vacio)");
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream != null) {
            stream.logStream();
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Response.StatusType getStatusInfo;
        String timestamp36 = (String)requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty((CharSequence)timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]");
        }
        String statusCode = (getStatusInfo = responseContext.getStatusInfo()) != null ? String.valueOf(getStatusInfo.getStatusCode()) : "N/A";
        String method = requestContext.getMethod();
        URI uriObject = requestContext.getUri();
        String uri = uriObject != null ? uriObject.toString() : "";
        MultivaluedMap headersMap = requestContext.getHeaders();
        String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)headersMap);
        String date = RestConnectorUtil.getFormattedDate(new Date());
        String respuesta = "[" + timestamp36 + "]:[RestConnector.clires],S=[" + statusCode + "]";
        boolean chunked = false;
        if (headersMap != null) {
            String transferEncoding = responseContext.getHeaderString("Transfer-Encoding");
            chunked = transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked");
        }
        File logFile = RestConnectorUtil.getLogFile(date, timestamp36, "cli", "res", RestConnectorUtil.createTag(method, uri));
        log.info(respuesta + ",logFile [" + logFile + "]");
        String entityStreamResult = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (responseContext.hasEntity() && !chunked) {
            entityStreamResult = IOUtils.toString((InputStream)responseContext.getEntityStream(), (Charset)StandardCharsets.UTF_8);
            baos.write(entityStreamResult.getBytes(StandardCharsets.UTF_8));
        } else if (chunked) {
            baos.write("(chunked)".getBytes(StandardCharsets.UTF_8));
        } else {
            baos.write("(vacio)".getBytes(StandardCharsets.UTF_8));
        }
        baos.close();
        byte[] bytes = baos.toByteArray();
        queuedLogWriterInstance.add(new QueueLogHolderByteArray(bytes, logFile.getAbsolutePath(), respuesta, timestamp36));
        if (responseContext.hasEntity() && !chunked && entityStreamResult != null) {
            responseContext.setEntityStream(IOUtils.toInputStream((String)entityStreamResult, (Charset)StandardCharsets.UTF_8));
        }
    }

    public static void setQueuedLogWriterInstance(QueuedLogWriter queuedLogWriterInstance) {
        ClientFileLoggingFilter.queuedLogWriterInstance = queuedLogWriterInstance;
    }

    private static class LoggingStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final String timestamp36;
        private final String date;
        private final String respuesta;
        private final String method;
        private final String uri;

        LoggingStream(OutputStream out, String date, String timestamp36, String respuesta, String method, String uri) {
            super(out);
            this.date = date;
            this.timestamp36 = timestamp36;
            this.respuesta = respuesta;
            this.method = method;
            this.uri = uri;
        }

        void logStream() throws IOException {
            File logFile = RestConnectorUtil.getLogFile(this.date, this.timestamp36, "cli", "req", RestConnectorUtil.createTag(this.method, this.uri));
            log.info(this.respuesta + ", logFile [" + logFile + "]");
            byte[] bytes = this.baos.toByteArray();
            queuedLogWriterInstance.add(new QueueLogHolderByteArray(bytes, logFile.getAbsolutePath(), this.respuesta, this.timestamp36));
        }

        @Override
        public void write(int i) throws IOException {
            this.baos.write(i);
            this.out.write(i);
        }
    }
}

