/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import ar.com.sdd.commons.rest.util.AliasSelectorKeyManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SSLSocketFactoryGenerator {
    public static String defaultProtocol = "TLSv1.2";
    private String alias = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;

    public SSLSocketFactoryGenerator(String alias, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias may not be null");
        }
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    public SSLSocketFactoryGenerator(String alias, String keyStore, String keyStorePassword) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias may not be null");
        }
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = keyStore;
        this.trustStorePassword = keyStorePassword;
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException, GeneralSecurityException {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasSelectorKeyManager((X509KeyManager)keyManagers[i], this.alias);
        }
        SSLContext context = SSLContext.getInstance(defaultProtocol);
        context.init(keyManagers, trustManagers, new SecureRandom());
        SSLSocketFactory ssf = context.getSocketFactory();
        return ssf;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    private KeyManager[] getKeyManagers() throws IOException, GeneralSecurityException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmFact = KeyManagerFactory.getInstance(alg);
        FileInputStream fis = new FileInputStream(this.getKeyStore());
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(fis, this.getKeyStorePassword().toCharArray());
        fis.close();
        kmFact.init(ks, this.getKeyStorePassword().toCharArray());
        KeyManager[] kms = kmFact.getKeyManagers();
        return kms;
    }

    protected TrustManager[] getTrustManagers() throws IOException, GeneralSecurityException {
        String alg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmFact = TrustManagerFactory.getInstance(alg);
        FileInputStream fis = new FileInputStream(this.getTrustStore());
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(fis, this.getTrustStorePassword().toCharArray());
        fis.close();
        tmFact.init(ks);
        TrustManager[] tms = tmFact.getTrustManagers();
        return tms;
    }
}

