package ar.com.sdd.commons.rest.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;

public class QueueLogHolderByteArray implements QueueLogHolder {

    private static final Logger log = LogManager.getLogger(QueueLogHolderByteArray.class);

    private final byte[] bytes;
    private final String logFileName;
    private final String respuesta;
    private final String timestamp36;

    public QueueLogHolderByteArray(byte[] bytes, String logFileName, String respuesta, String timestamp36) {
        this.bytes = bytes;
        this.logFileName = logFileName;
        this.respuesta = respuesta;
        this.timestamp36 = timestamp36;
    }


    @Override
    public void log() {
        File logFile = new File(logFileName);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(logFile))) {
            bos.write((respuesta + "\n").getBytes(StandardCharsets.UTF_8));
            bos.write(bytes);
        } catch (Exception e) {
            log.error("[" + timestamp36 + "] No se pudo escribir el archivo de log [" + logFileName + "]", e);
        }

    }
}
