package ar.com.sdd.commons.rest.util;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;

import java.text.FieldPosition;
import java.util.Date;

public class RFC3339DateFormat extends ISO8601DateFormat {

    // Same as ISO8601DateFormat but serializing milliseconds.
    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        String value = ISO8601Utils.format(date, true);
        //DateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        //DateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.sss'Z'");
        toAppendTo.append(value);
        return toAppendTo;
    }

}