/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class RestConnectorUtil {
    public static final int MAX_ENTITY_SIZE = 8192;
    public static final int MAX_FILENAME_NO_EXT_SIZE = 251;

    public static String getCacheSafeValue() {
        long ts = System.currentTimeMillis();
        return Long.toString(ts, 36);
    }

    public static File getLogFile(String formattedDate, String timestamp36, String serverClientTag, String requestResponseTag, String tag) throws IOException {
        String subdirTag = formattedDate.substring(0, 11);
        Object logFilenameNoExt = "restconnector_" + serverClientTag + "_" + formattedDate + "_" + requestResponseTag + "_" + timestamp36 + (String)(tag != null ? "_" + tag : "");
        if (((String)logFilenameNoExt).length() > 251) {
            logFilenameNoExt = ((String)logFilenameNoExt).substring(0, 251);
        }
        return new File(FilenameUtils.concat((String)RestConnectorUtil.getLogDirectory(subdirTag), (String)((String)logFilenameNoExt + ".log")));
    }

    private static String getLogDirectory() throws IOException {
        return RestConnectorUtil.getLogDirectory(null);
    }

    private static String getLogDirectory(String subdir) throws IOException {
        File logDirectoryAgain;
        boolean result;
        Path path;
        File logDirectory;
        String jbossLogDir = System.getProperty("jboss.server.log.dir");
        if (jbossLogDir == null) {
            jbossLogDir = ".";
        }
        if (!((logDirectory = new File((path = subdir != null ? Paths.get(jbossLogDir, "io", subdir) : Paths.get(jbossLogDir, "io")).toUri())).exists() || (result = logDirectory.mkdirs()) || (logDirectoryAgain = new File(path.toUri())).exists())) {
            throw new IOException("No se pudo crear el directorio de log [" + logDirectory + "]");
        }
        return logDirectory.getAbsolutePath();
    }

    public static String createTag(String method, String uri) {
        uri = uri.replace("?", "_").replace("&", "_").replace("//", "").replace("https", "").replace("http", "").replace(":", "").replace("=", "_").replace("/", "_").replace(".", "_").replace(",", "_").replace("__", "_");
        if (method != null) {
            switch (method.toUpperCase()) {
                case "GET": {
                    method = "GET";
                    break;
                }
                case "POST": {
                    method = "POS";
                    break;
                }
                case "PUT": {
                    method = "PUT";
                    break;
                }
                case "DELETE": {
                    method = "DEL";
                    break;
                }
                case "HEAD": {
                    method = "HEA";
                    break;
                }
                case "OPTIONS": {
                    method = "OPT";
                    break;
                }
                case "PATCH": {
                    method = "PAT";
                    break;
                }
                default: {
                    method = "UNK";
                    break;
                }
            }
        } else {
            method = "   ";
        }
        return method + "_" + uri;
    }

    public static String getHeadersStringObject(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (String headerKey : headers.keySet()) {
            List values = (List)headers.get((Object)headerKey);
            sep = RestConnectorUtil.getHeaderValues(result, sep, headerKey, values);
        }
        return result.toString();
    }

    public static String getHeadersStringString(MultivaluedMap<String, String> headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (String headerKey : headers.keySet()) {
            List values = (List)headers.get((Object)headerKey);
            sep = RestConnectorUtil.getHeaderValues(result, sep, headerKey, new ArrayList<Object>(values));
        }
        return result.toString();
    }

    private static String getHeaderValues(StringBuilder result, String sep, String headerKey, List<Object> values) {
        result.append(sep).append(headerKey).append(":");
        if (values != null && values.size() > 0) {
            if (values.size() > 1) {
                result.append("[");
            }
            String valueSep = "";
            for (Object value : values) {
                result.append(valueSep).append(value);
                valueSep = ";";
            }
            if (values.size() > 1) {
                result.append("]");
            }
        }
        sep = "|";
        return sep;
    }

    public static String getBasicAuthHeader(String user, String pass) {
        if (user == null) {
            user = "";
        }
        if (pass == null) {
            pass = "";
        }
        String authString = user + ":" + pass;
        String authStringEnc = Base64.getEncoder().encodeToString(authString.getBytes());
        return "Basic " + authStringEnc;
    }

    public static String getFormattedDate(Date date) {
        return DateFormatUtils.format((Date)date, (String)"yyyyMMdd-HHmmss-SSS");
    }
}

