package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

@ServerLogged
@Provider
public class ServerLogginFilter implements ContainerRequestFilter, ContainerResponseFilter {

    private static final Logger log = LogManager.getLogger(ServerLogginFilter.class);
    private static final Logger logAll = LogManager.getLogger("ar.com.sdd.commons.rest.log.LogAll");

    /**
     * Request filter
     *
     * @param requestContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(requestContext.getEntityStream(), baos);
        byte[] bytes = baos.toByteArray();
        String payload = new String(bytes, StandardCharsets.UTF_8);
        String headers = RestConnectorUtil.getHeadersStringString(requestContext.getHeaders());
        String timestamp36 =RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", timestamp36);
        StringBuffer respuesta = new StringBuffer();
        respuesta.append("[").append(timestamp36).append("]:[RestConnector.serreq][").append(requestContext.getMethod()).append("],H=[").append(headers).append("],URI=[").append(requestContext.getUriInfo().getRequestUri()).append("]:");
        logAll.trace(respuesta + payload);
        if (payload.length() > RestConnectorUtil.MAX_ENTITY_SIZE) {
            payload = payload.substring(0, RestConnectorUtil.MAX_ENTITY_SIZE) + "...more...";
        }
        log.info(respuesta + payload);
        requestContext.setEntityStream(new ByteArrayInputStream(bytes));
    }

    /**
     * Response filter
     *
     * @param requestContext
     * @param responseContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String timestamp36 = (String) requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty(timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]");
        }
        String headers = RestConnectorUtil.getHeadersStringString(requestContext.getHeaders());
        String respuesta = "[" + timestamp36 + "]:[RestConnector.clires],S=[" + responseContext.getStatus() + "]:";
        Object entity = responseContext.getEntity();
        if (entity != null) {
            String payload = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity);
            logAll.trace(respuesta + payload);
            if (payload.length() > RestConnectorUtil.MAX_ENTITY_SIZE) {
                payload = payload.substring(0, RestConnectorUtil.MAX_ENTITY_SIZE) + "...more...";
            }
            log.info(respuesta + payload);
        } else {
            logAll.trace(respuesta + "(vacio)");
            log.info(respuesta + "(vacio)");
        }
    }
}
