package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TokenOAuth2 implements Serializable {

    @JsonProperty("access_token")
    private String accessToken = null;
    @JsonProperty("token_type")
    private String tokenType = null;
    @JsonProperty("expires_in")
    private Integer expiresIn = null;

    public TokenOAuth2() {

    }

    /**
     * Token devuelto
     **/


    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * El tipo de token devuelto (Bearer)
     **/


    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    /**
     * Tiempo de expiración del token en minutos
     **/


    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }


    @Override
    public String toString() {
        return "TokenOAuth2 ["
                + ((accessToken != null) ? "accessToken=" + accessToken + ", " : "")
                + ((tokenType != null) ? "tokenType=" + tokenType + ", " : "")
                + ((expiresIn != null) ? "expiresIn=" + expiresIn+ ", " : "")
               + "]";
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TokenOAuth2 that = (TokenOAuth2) o;

        if (accessToken != null ? !accessToken.equals(that.accessToken) : that.accessToken != null) return false;
        if (tokenType != null ? !tokenType.equals(that.tokenType) : that.tokenType != null) return false;
        return expiresIn != null ? expiresIn.equals(that.expiresIn) : that.expiresIn == null;
    }

    @Override
    public int hashCode() {
        int result = accessToken != null ? accessToken.hashCode() : 0;
        result = 31 * result + (tokenType != null ? tokenType.hashCode() : 0);
        result = 31 * result + (expiresIn != null ? expiresIn.hashCode() : 0);
        return result;
    }
}

