/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Priority(value=-2147483648)
public class ClientLoggerLoggingFilter
implements ClientLoggingFilter {
    private static final Logger log = LogManager.getLogger(ClientLoggerLoggingFilter.class);
    private static final Logger logAll = LogManager.getLogger((String)"ar.com.sdd.commons.rest.log.LogAll");
    private static final String ENTITY_STREAM_PROPERTY = "ClientLoggingFilter.entityStream";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public void filter(ClientRequestContext requestContext) {
        String timestamp36 = RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", (Object)timestamp36);
        if (requestContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(requestContext.getEntityStream(), timestamp36, requestContext.getUri(), requestContext.getMethod(), (MultivaluedMap<String, Object>)requestContext.getHeaders());
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        } else {
            String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "N/A";
            String method = requestContext.getMethod() != null ? requestContext.getMethod() : "N/A";
            String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
            StringBuilder respuesta = new StringBuilder();
            respuesta.append("[").append(timestamp36).append("]:[RestConnector.clireq][").append(method).append("],H=[").append(headers).append("],URI=[").append(uri).append("]:NO_ENTITY");
            log.info((CharSequence)respuesta);
            logAll.trace((CharSequence)respuesta);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream != null) {
            stream.logStream();
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        boolean chunked;
        StringBuilder sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
        boolean bl = chunked = responseContext.getHeaders() != null && responseContext.getHeaderString("Transfer-Encoding") != null && responseContext.getHeaderString("Transfer-Encoding").equalsIgnoreCase("chunked");
        if (responseContext.hasEntity()) {
            responseContext.setEntityStream(this.logInboundEntity(requestContext, responseContext, chunked));
        } else {
            String timestamp36 = (String)requestContext.getProperty("timestamp36");
            if (StringUtils.isEmpty((CharSequence)timestamp36)) {
                timestamp36 = RestConnectorUtil.getCacheSafeValue();
                log.warn("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]");
            }
            String statusCode = responseContext.getStatusInfo() != null ? String.valueOf(responseContext.getStatusInfo().getStatusCode()) : "N/A";
            String method = requestContext.getMethod();
            String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "";
            String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
            sb.append("[").append(timestamp36).append("]:[RestConnector.clires][,S=[").append(statusCode).append("]:NO_ENTITY");
        }
        log.info((CharSequence)sb);
        logAll.trace((CharSequence)sb);
    }

    private InputStream logInboundEntity(ClientRequestContext requestContext, ClientResponseContext responseContext, boolean chunked) throws IOException {
        InputStream stream = responseContext.getEntityStream();
        String result = IOUtils.toString((InputStream)stream, (Charset)DEFAULT_CHARSET);
        StringBuilder sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
        String timestamp36 = (String)requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty((CharSequence)timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]");
        }
        String statusCode = responseContext.getStatusInfo() != null ? String.valueOf(responseContext.getStatusInfo().getStatusCode()) : "N/A";
        String method = requestContext.getMethod();
        String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "";
        String headers = RestConnectorUtil.getHeadersStringObject((MultivaluedMap<String, Object>)requestContext.getHeaders());
        sb.append("[").append(timestamp36).append("]:[RestConnector.clires][,S=[").append(statusCode).append("]:NO_ENTITY");
        if (chunked) {
            sb.append("[chunked]");
            log.info((CharSequence)sb);
            logAll.trace((CharSequence)sb);
        } else {
            if (result.length() > 8192) {
                log.info(sb.substring(0, 8192) + "...more...");
            } else {
                log.info((CharSequence)sb);
            }
            logAll.trace((CharSequence)sb);
        }
        return IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8);
    }

    private static class LoggingStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final String timestamp36;
        private final URI uri;
        private final String method;
        private final MultivaluedMap<String, Object> headers;

        LoggingStream(OutputStream out, String timestamp36, URI uri, String method, MultivaluedMap<String, Object> headers) {
            super(out);
            this.uri = uri;
            this.timestamp36 = timestamp36;
            this.method = method;
            this.headers = headers;
        }

        void logStream() {
            byte[] entity = this.baos.toByteArray();
            String headersString = RestConnectorUtil.getHeadersStringObject(this.headers);
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.timestamp36).append("]:[RestConnector.clireq]").append(this.method).append("],H=[").append(this.headers).append("],URI=[").append(this.uri).append("]");
            sb.append(new String(entity, 0, entity.length, DEFAULT_CHARSET));
            logAll.trace((CharSequence)sb);
            if (entity.length > 8192) {
                log.info(sb.substring(0, 8192) + "...more...");
            } else {
                log.info((CharSequence)sb);
            }
        }

        @Override
        public void write(int i) throws IOException {
            this.baos.write(i);
            this.out.write(i);
        }
    }
}

