package ar.com.sdd.commons.rest.util;

import javax.ws.rs.core.Response;

/**
 * Proporciona una clase de la que se permite obtener un resultado de una operacion,
 * o un objeto Response para devolver al cliente
 *
 * @param <T>
 */
public class RestConnectorResultOrResponse<T> {

    private T result;
    private Response response;
    private boolean responseNeeded;

    public RestConnectorResultOrResponse() {

    }

    public RestConnectorResultOrResponse(Response response) {
        this.response = response;
        responseNeeded = true;
    }

    public RestConnectorResultOrResponse(T result) {
        this.result = result;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public Response getResponse() {
        return response;
    }

    public void setResponse(Response response) {
        this.response = response;

        //Automaticamente seteo el responseNeeded
        responseNeeded = true;
    }

    public boolean isResponseNeeded() {
        return responseNeeded;
    }

    @Override
    public String toString() {
        return "RestConnectorResultOrResponse ["
                + ((result != null) ? "result=" + result + ", " : "")
                + ((response != null) ? "response=" + response + ", " : "")
                + "responseNeeded=" + responseNeeded
                + "]";
    }
}
