package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@SuppressWarnings("unused")
@JsonIgnoreProperties(ignoreUnknown = true)
public class TokenOAuth2 implements Serializable {

    @JsonProperty("access_token")
    private String accessToken = null;
    @JsonProperty("token_type")
    private String tokenType = null;
    @JsonProperty("expires_in")
    private Integer expiresIn = null;
    @JsonProperty("refresh_expires_in")
    private Integer refreshExpiresIn = null;
    @JsonProperty("refresh_token")
    private String refreshToken = null;
    @JsonProperty("not-before-policy")
    private Integer notBeforePolicy = null;
    @JsonProperty("session_state")
    private String sessionState = null;
    @JsonProperty("scope")
    private String scope = null;

    public TokenOAuth2() {

    }

    /**
     * Token devuelto
     **/
    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * El tipo de token devuelto (Bearer)
     **/
    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    /**
     * Tiempo de expiración del token en minutos
     **/
    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Integer getRefreshExpiresIn() {
        return refreshExpiresIn;
    }

    public void setRefreshExpiresIn(Integer refreshExpiresIn) {
        this.refreshExpiresIn = refreshExpiresIn;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Integer getNotBeforePolicy() {
        return notBeforePolicy;
    }

    public void setNotBeforePolicy(Integer notBeforePolicy) {
        this.notBeforePolicy = notBeforePolicy;
    }

    public String getSessionState() {
        return sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String toString() {
        return "TokenOAuth2 [" +
                ((accessToken != null) ? "accessToken='" + accessToken + "', " : "") +
                ((tokenType != null) ? "tokenType='" + tokenType + "', " : "") +
                ((expiresIn != null) ? "expiresIn=" + expiresIn + ", " : "") +
                ((refreshExpiresIn != null) ? "refreshExpiresIn=" + refreshExpiresIn + ", " : "") +
                ((refreshToken != null) ? "refreshToken='" + refreshToken + "', " : "") +
                ((notBeforePolicy != null) ? "notBeforePolicy=" + notBeforePolicy + ", " : "") +
                ((sessionState != null) ? "sessionState='" + sessionState + "', " : "") +
                ((scope != null) ? "scope='" + scope + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TokenOAuth2 that = (TokenOAuth2) o;
        return Objects.equals(accessToken, that.accessToken) && Objects.equals(tokenType, that.tokenType) && Objects.equals(expiresIn, that.expiresIn) && Objects.equals(refreshExpiresIn, that.refreshExpiresIn) && Objects.equals(refreshToken, that.refreshToken) && Objects.equals(notBeforePolicy, that.notBeforePolicy) && Objects.equals(sessionState, that.sessionState) && Objects.equals(scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessToken, tokenType, expiresIn, refreshExpiresIn, refreshToken, notBeforePolicy, sessionState, scope);
    }
}