/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.log.ClientFileLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggerLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import ar.com.sdd.commons.rest.util.SSLSocketFactoryGenerator;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestConnector {
    private static final Logger log = LogManager.getLogger(RestConnector.class);
    private RestConnectorEnvironment environment;
    private RestSecurityManager securityManager;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private boolean useKeyStoreWithEmbeddedTrustStore;
    private ClientLoggingFilter clientLoggingFilter;

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager) {
        this(environment, securityManager, true);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile) {
        this(environment, securityManager, true, false);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile, boolean useKeyStoreWithEmbeddedTrustStore) {
        this.environment = environment;
        this.securityManager = securityManager;
        if (!StringUtils.isEmpty((CharSequence)environment.keyStorePath)) {
            try {
                this.keyStore = this.loadStore(environment.keyStorePath, environment.keyStorePassword);
            }
            catch (Exception e) {
                log.error("No se pudo cargar el keystore de [" + environment.keyStorePath + "] con password [" + environment.keyStorePassword + "]", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)environment.trustStorePath)) {
            try {
                this.trustStore = this.loadStore(environment.trustStorePath, environment.trustStorePassword);
            }
            catch (Exception e) {
                log.error("No se pudo cargar el trustStore de [" + environment.trustStorePath + "] con password [" + environment.trustStorePassword + "]", (Throwable)e);
            }
        }
        if (useKeyStoreWithEmbeddedTrustStore) {
            log.debug("Usando el keyStore [" + environment.keyStorePath + "] como trustStore");
            this.trustStore = this.keyStore;
        }
        this.clientLoggingFilter = logClientToFile ? new ClientFileLoggingFilter() : new ClientLoggerLoggingFilter();
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, null, path, (Map<String, Object>)null);
    }

    public <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericGet(request, responseType, errorType, path, null);
    }

    public <Res, Req> Res genericGet(Req request, Class<Res> responseType, String path, String templateKey, String templateValue) throws RestConnectorException {
        return this.genericGet(request, responseType, null, path, templateKey, templateValue);
    }

    public <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return this.genericGet(request, responseType, errorType, path, templateParameters);
    }

    public <Res, Req, Err> Res genericGet(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.genericGetWithResponseHeader(request, responseType, errorType, path, templateParameters).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericGetWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericGetWithResponseHeader(request, responseType, errorType, path, templateParameters, 0, 1L);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericGetWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis) throws RestConnectorException {
        log.trace("[RestConnector] Get client request [" + request + "]");
        RestConnectorException lastException = null;
        while (retryCount >= 0) {
            Pair pair;
            block11: {
                Response getResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).get();
                try {
                    log.trace("[RestConnector] Get client response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]");
                    this.checkSuccessfulOrException(getResponse, errorType);
                    pair = Pair.of(this.processResponse(getResponse, responseType), (Object)getResponse.getHeaders());
                    if (getResponse == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (getResponse != null) {
                            try {
                                getResponse.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessingException e) {
                        lastException = new RestConnectorException("Error de comunicaciones", e);
                        --retryCount;
                        try {
                            Thread.sleep(retryWaitMillis);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            lastException = new RestConnectorException("Error en wait", e2);
                        }
                    }
                }
                getResponse.close();
            }
            return pair;
        }
        throw lastException;
    }

    public <Req, Err> String genericGetTextResponse(Req request, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        String string;
        block8: {
            log.trace("[RestConnector] Get client request [" + request + "] con text response");
            Response getResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"text/plain"}).get();
            try {
                log.trace("[RestConnector] Get client text response [" + getResponse.getStatus() + "/" + getResponse.getStatusInfo() + "]");
                this.checkSuccessfulOrException(getResponse, errorType);
                string = this.processResponse(getResponse, String.class);
                if (getResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (getResponse != null) {
                        try {
                            getResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException e) {
                    throw new RestConnectorException("Error de comunicaciones", e);
                }
            }
            getResponse.close();
        }
        return string;
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericPost(request, responseType, path, "application/json", "application/json", null);
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPost(request, responseType, path, "application/json", "application/json", templateParameters);
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, path, "application/json", "application/json", null);
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, path, "application/json", "application/json", templateParameters);
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPost(request, responseType, null, path, acceptMediaType, postMediaType, null);
    }

    public <Res, Req> Res genericPost(Req request, Class<Res> responseType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPost(request, responseType, null, path, acceptMediaType, postMediaType, templateParameters);
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, null, path, acceptMediaType, postMediaType, null);
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, null, path, acceptMediaType, postMediaType, templateParameters);
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericPost(request, responseType, errorType, path, "application/json", "application/json", null);
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPost(request, responseType, errorType, path, "application/json", "application/json", templateParameters);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, errorType, path, "application/json", "application/json", null);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, errorType, path, "application/json", "application/json", templateParameters);
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return (Res)this.genericPostWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, null).getKey();
    }

    public <Res, Req, Err> Res genericPost(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.genericPostWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, templateParameters).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, null);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, templateParameters, 1, 0L);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, int retryCount, long retryWaitMillis) throws RestConnectorException {
        return this.genericPostWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, null, retryCount, retryWaitMillis);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis) throws RestConnectorException {
        log.trace("[RestConnector] Post cliente request [" + request + "]");
        RestConnectorException lastException = null;
        while (retryCount >= 0) {
            Pair pair;
            block11: {
                Response postResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{acceptMediaType}).post(Entity.entity(request, (String)postMediaType));
                try {
                    log.trace("[RestConnector] Post cliente response [" + postResponse.getStatus() + "/" + postResponse.getStatusInfo() + "]");
                    this.checkSuccessfulOrException(postResponse, errorType);
                    pair = Pair.of(this.processResponse(postResponse, responseType), (Object)postResponse.getHeaders());
                    if (postResponse == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (postResponse != null) {
                            try {
                                postResponse.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessingException e) {
                        lastException = new RestConnectorException("Error de comunicaciones", e);
                        --retryCount;
                        try {
                            Thread.sleep(retryWaitMillis);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            lastException = new RestConnectorException("Error en wait", e2);
                        }
                    }
                }
                postResponse.close();
            }
            return pair;
        }
        throw lastException;
    }

    public <Res, Req> Res genericPut(Req request, Class<Res> responseType, String path) throws RestConnectorException {
        return this.genericPut(request, responseType, null, path, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.genericPut(request, responseType, errorType, path, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.genericPut(request, responseType, errorType, path, acceptMediaType, postMediaType, null);
    }

    public <Res, Req, Err> Res genericPut(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.genericPutWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, null).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPutWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPutWithResponseHeader(request, responseType, errorType, path, acceptMediaType, postMediaType, templateParameters, 1, 0L);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPutWithResponseHeader(Req request, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis) throws RestConnectorException {
        log.trace("[RestConnector] Put cliente request [" + request + "]");
        RestConnectorException lastException = null;
        while (retryCount >= 0) {
            block13: {
                Pair pair;
                block12: {
                    Response putResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{acceptMediaType}).put(Entity.entity(request, (String)postMediaType));
                    try {
                        log.trace("[RestConnector] Put cliente response [" + putResponse.getStatus() + "/" + putResponse.getStatusInfo() + "]");
                        this.checkSuccessfulOrException(putResponse, errorType);
                        pair = Pair.of(this.processResponse(putResponse, responseType), (Object)putResponse.getHeaders());
                        if (putResponse == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (putResponse != null) {
                                try {
                                    putResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ProcessingException e) {
                            lastException = new RestConnectorException("Error de comunicaciones", e);
                            break block13;
                        }
                        catch (Exception e) {
                            lastException = new RestConnectorException("Error general", e);
                        }
                    }
                    putResponse.close();
                }
                return pair;
            }
            --retryCount;
            try {
                Thread.sleep(retryWaitMillis);
            }
            catch (InterruptedException e) {
                lastException = new RestConnectorException("Error en wait", e);
            }
        }
        throw lastException;
    }

    public <Res, Req> Res genericDelete(Req request, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericDelete(request, responseType, null, path, templateParameters);
    }

    public <Res, Req, Err> Res genericDelete(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericDelete(request, responseType, errorType, path, templateParameters, 1, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Res, Req, Err> Res genericDelete(Req request, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis) throws RestConnectorException {
        log.trace("[RestConnector] Delete cliente request [" + request + "]");
        RestConnectorException lastException = null;
        while (retryCount >= 0) {
            try (Response deleteResponse = this.buildRequest(this.environment.baseUrl + path, templateParameters).accept(new String[]{"application/json"}).delete();){
                log.trace("[RestConnector] Delete cliente response [" + deleteResponse.getStatus() + "/" + deleteResponse.getStatusInfo() + "]");
                this.checkSuccessfulOrException(deleteResponse, errorType);
                Object entityResponse = deleteResponse.readEntity(responseType);
                log.trace("[RestConnector] Entity response [" + entityResponse + "]");
                Object object = entityResponse;
                return (Res)object;
            }
            catch (ProcessingException e) {
                lastException = new RestConnectorException("Error de comunicaciones", e);
                --retryCount;
                try {
                    Thread.sleep(retryWaitMillis);
                }
                catch (InterruptedException e2) {
                    lastException = new RestConnectorException("Error en wait", e2);
                }
            }
        }
        throw lastException;
    }

    private <Err> void checkSuccessfulOrException(Response response, Class<Err> errorType) throws RestConnectorException {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Object entityResponseError = null;
            if (errorType != null) {
                try {
                    response.bufferEntity();
                    entityResponseError = response.readEntity(errorType);
                    log.trace("[RestConnector] Entity responseError [" + entityResponseError + "]");
                }
                catch (Exception e) {
                    entityResponseError = response.readEntity(String.class);
                    log.debug("La consulta no tiene tipo[" + errorType.getCanonicalName() + "]");
                }
            } else {
                entityResponseError = response.readEntity(String.class);
            }
            throw new RestConnectorException("La consulta no devolvio OK. Status: [" + response.getStatus() + "/" + response.getStatusInfo() + "]", response.getStatus(), response.getStatusInfo(), entityResponseError);
        }
    }

    private <Res> Res processResponse(Response response, Class<Res> responseType) throws RestConnectorException {
        Object entityResponse;
        if (response.getEntity() == null || responseType == Void.class) {
            entityResponse = null;
            log.trace("[RestConnector] Entity response [vacio]");
        } else {
            try {
                response.bufferEntity();
                entityResponse = response.readEntity(responseType);
                log.trace("[RestConnector] Entity response [" + entityResponse + "]");
            }
            catch (Exception e) {
                String stringResponse = (String)response.readEntity(String.class);
                throw new RestConnectorException("La consulta no tiene tipo[" + responseType.getCanonicalName() + "]. Resultado: [" + stringResponse + "]", e);
            }
        }
        return (Res)entityResponse;
    }

    public Invocation.Builder buildRequest(String url, Map<String, Object> templateParameters) throws RestConnectorException {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.keyStore != null) {
            builder.keyStore(this.keyStore, this.environment.keyStorePassword);
        }
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        if (this.securityManager != null && this.securityManager.getDisableHTTPSErrors()) {
            SSLContext sslContext = null;
            TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                sslContext = SSLContext.getInstance(SSLSocketFactoryGenerator.defaultProtocol);
                String alg = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmFact = KeyManagerFactory.getInstance(alg);
                kmFact.init(this.keyStore, this.environment.keyStorePassword != null ? this.environment.keyStorePassword.toCharArray() : null);
                KeyManager[] kms = kmFact.getKeyManagers();
                sslContext.init(kms, trustAllCerts, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException alg) {
            }
            catch (KeyStoreException | UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
            builder.sslContext(sslContext);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        WebTarget resource = builder.build().target(url);
        resource.register((Object)this.clientLoggingFilter);
        if (templateParameters != null) {
            resource = resource.resolveTemplates(templateParameters);
        }
        Invocation.Builder request = resource.request();
        if (this.securityManager != null) {
            request = this.securityManager.addHeaders(request);
        }
        return request;
    }

    private KeyStore loadStore(String storePath, String storePassword) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(new FileInputStream(storePath), storePassword != null ? storePassword.toCharArray() : null);
        return store;
    }
}

