/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.core;

import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.core.RestSignSecurityManager;
import ar.com.sdd.commons.rest.log.ClientFileLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggerLoggingFilter;
import ar.com.sdd.commons.rest.log.ClientLoggingFilter;
import ar.com.sdd.commons.rest.util.SSLSocketFactoryGenerator;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestConnector {
    private static final Logger log = LogManager.getLogger(RestConnector.class);
    private static final int DEFAULT_RETRY = 1;
    private static final int DEFAULT_RETRY_MILLIS = 10;
    private RestConnectorEnvironment environment;
    private RestSecurityManager securityManager;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private boolean useKeyStoreWithEmbeddedTrustStore;
    private ClientLoggingFilter clientLoggingFilter;

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager) {
        this(environment, securityManager, true);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile) {
        this(environment, securityManager, true, false);
    }

    public RestConnector(RestConnectorEnvironment environment, RestSecurityManager securityManager, boolean logClientToFile, boolean useKeyStoreWithEmbeddedTrustStore) {
        this.environment = environment;
        this.securityManager = securityManager;
        if (!StringUtils.isEmpty((CharSequence)environment.keyStorePath)) {
            try {
                this.keyStore = this.loadStore(environment.keyStorePath, environment.keyStorePassword);
            }
            catch (Exception e) {
                log.error("No se pudo cargar el keystore de [" + environment.keyStorePath + "] con password [" + environment.keyStorePassword + "]", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)environment.trustStorePath)) {
            try {
                this.trustStore = this.loadStore(environment.trustStorePath, environment.trustStorePassword);
            }
            catch (Exception e) {
                log.error("No se pudo cargar el trustStore de [" + environment.trustStorePath + "] con password [" + environment.trustStorePassword + "]", (Throwable)e);
            }
        }
        if (useKeyStoreWithEmbeddedTrustStore) {
            log.debug("Usando el keyStore [{}}] como trustStore", (Object)environment.keyStorePath);
            this.trustStore = this.keyStore;
        }
        this.clientLoggingFilter = logClientToFile ? new ClientFileLoggingFilter() : new ClientLoggerLoggingFilter();
    }

    public <Res, Req> Res genericGet(Req requestBody, Class<Res> responseType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("GET", requestBody, responseType, null, path, null, 1, 10L, "application/json", null).getKey();
    }

    public <Res, Req, Err> Res genericGet(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("GET", requestBody, responseType, errorType, path, null, 1, 10L, "application/json", null).getKey();
    }

    public <Res, Req> Res genericGet(Req requestBody, Class<Res> responseType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return (Res)this.internalGenericRequest("GET", requestBody, responseType, null, path, templateParameters, 1, 10L, "application/json", null).getKey();
    }

    public <Res, Req, Err> Res genericGet(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String templateKey, String templateValue) throws RestConnectorException {
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        templateParameters.put(templateKey, templateValue);
        return (Res)this.internalGenericRequest("GET", requestBody, responseType, errorType, path, templateParameters, 1, 10L, "application/json", null).getKey();
    }

    public <Res, Req, Err> Res genericGet(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("GET", requestBody, responseType, errorType, path, templateParameters, 1, 10L, "application/json", null).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericGetWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.internalGenericRequest("GET", requestBody, responseType, errorType, path, templateParameters, 1, 10L, "application/json", null);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericGetWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis) throws RestConnectorException {
        return this.internalGenericRequest("GET", requestBody, responseType, errorType, path, templateParameters, retryCount, retryWaitMillis, "application/json", null);
    }

    public <Req, Err> String genericGetTextResponse(Req requestBody, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (String)this.internalGenericRequest("GET", requestBody, String.class, errorType, path, templateParameters, 1, 10L, "text/plain", null).getKey();
    }

    public <Res, Req> Res genericPost(Req requestBody, Class<Res> responseType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, null, path, null, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req> Res genericPost(Req requestBody, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, null, path, templateParameters, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, String path) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, null, path, null, 1, 10L, "application/json", "application/json");
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.genericPostWithResponseHeader(requestBody, responseType, path, "application/json", "application/json", templateParameters);
    }

    public <Res, Req> Res genericPost(Req requestBody, Class<Res> responseType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, null, path, null, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req> Res genericPost(Req requestBody, Class<Res> responseType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, null, path, templateParameters, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, null, path, null, 1, 10L, acceptMediaType, postMediaType);
    }

    public <Res, Req> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, null, path, templateParameters, 1, 10L, acceptMediaType, postMediaType);
    }

    public <Res, Req, Err> Res genericPost(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, errorType, path, null, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req, Err> Res genericPost(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, errorType, path, templateParameters, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, errorType, path, null, 1, 10L, "application/json", "application/json");
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, errorType, path, templateParameters, 1, 10L, "application/json", "application/json");
    }

    public <Res, Req, Err> Res genericPost(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, errorType, path, null, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req, Err> Res genericPost(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("POST", requestBody, responseType, errorType, path, templateParameters, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, errorType, path, null, 1, 10L, acceptMediaType, postMediaType);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, errorType, path, templateParameters, 1, 10L, acceptMediaType, postMediaType);
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPostWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, int retryCount, long retryWaitMillis) throws RestConnectorException {
        return this.internalGenericRequest("POST", requestBody, responseType, errorType, path, null, retryCount, retryWaitMillis, acceptMediaType, postMediaType);
    }

    public <Res, Req> Res genericPut(Req requestBody, Class<Res> responseType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("PUT", requestBody, responseType, null, path, null, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req, Err> Res genericPut(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path) throws RestConnectorException {
        return (Res)this.internalGenericRequest("PUT", requestBody, responseType, errorType, path, null, 1, 10L, "application/json", "application/json").getKey();
    }

    public <Res, Req, Err> Res genericPut(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType) throws RestConnectorException {
        return (Res)this.internalGenericRequest("PUT", requestBody, responseType, errorType, path, null, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req, Err> Res genericPut(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("PUT", requestBody, responseType, errorType, path, templateParameters, 1, 10L, acceptMediaType, postMediaType).getKey();
    }

    public <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> genericPutWithResponseHeader(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, String acceptMediaType, String postMediaType, Map<String, Object> templateParameters) throws RestConnectorException {
        return this.internalGenericRequest("PUT", requestBody, responseType, errorType, path, templateParameters, 1, 10L, acceptMediaType, postMediaType);
    }

    public <Res, Req> Res genericDelete(Req requestBody, Class<Res> responseType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("DELETE", requestBody, responseType, null, path, templateParameters, 1, 10L, null, null).getKey();
    }

    public <Res, Req, Err> Res genericDelete(Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters) throws RestConnectorException {
        return (Res)this.internalGenericRequest("DELETE", requestBody, responseType, errorType, path, templateParameters, 1, 10L, null, null).getKey();
    }

    private <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> internalGenericRequest(String method, Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis, String acceptMediaType, String postMediaType) throws RestConnectorException {
        try {
            return this.internalGenericRequestrNotryOnAuth(method, requestBody, responseType, errorType, path, templateParameters, retryCount, retryWaitMillis, acceptMediaType, postMediaType);
        }
        catch (RestConnectorException e) {
            if (e.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode() && this.securityManager.retryOnUnauthorized()) {
                log.error("Retry por autorizacional hacer GET para request [{}] con path [{}]. Se reconsulta", requestBody, (Object)path);
                return this.internalGenericRequestrNotryOnAuth(method, requestBody, responseType, errorType, path, templateParameters, retryCount, retryWaitMillis, acceptMediaType, postMediaType);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Res, Req, Err> Pair<Res, MultivaluedMap<String, Object>> internalGenericRequestrNotryOnAuth(String method, Req requestBody, Class<Res> responseType, Class<Err> errorType, String path, Map<String, Object> templateParameters, int retryCount, long retryWaitMillis, String acceptMediaType, String postMediaType) throws RestConnectorException {
        log.trace("[RestConnector] {} client request [{}}]", (Object)method, requestBody);
        RestConnectorException lastException = null;
        Invocation.Builder buildRequest = this.buildRequest(this.environment.baseUrl + path, templateParameters);
        Entity entity = null;
        if (requestBody != null) {
            entity = Entity.entity(requestBody, (String)postMediaType);
        }
        if (this.securityManager != null) {
            if (this.securityManager instanceof RestSignSecurityManager) {
                RestSignSecurityManager restSignSecurityManager = (RestSignSecurityManager)this.securityManager;
                if (requestBody != null) {
                    String stringRequest = requestBody.toString();
                    entity = Entity.entity((Object)stringRequest, (String)postMediaType);
                    buildRequest = restSignSecurityManager.addHeaders(buildRequest, stringRequest);
                } else {
                    buildRequest = restSignSecurityManager.addHeaders(buildRequest, null);
                }
            } else {
                buildRequest = this.securityManager.addHeaders(buildRequest);
            }
        }
        Invocation.Builder buildResponse = buildRequest.accept(new String[]{acceptMediaType});
        while (retryCount >= 0) {
            try (Response response = null;){
                switch (method) {
                    case "GET": {
                        response = buildResponse.get();
                        break;
                    }
                    case "POST": {
                        response = buildResponse.post(entity);
                        break;
                    }
                    case "PUT": {
                        response = buildResponse.put(entity);
                        break;
                    }
                    case "DELETE": {
                        response = buildResponse.delete();
                        break;
                    }
                    default: {
                        throw new RestConnectorException("Invalid method:" + method);
                    }
                }
                log.trace("[RestConnector] {} client response [{}/{}]", (Object)method, (Object)response.getStatus(), (Object)response.getStatusInfo());
                this.checkSuccessfulOrException(response, errorType);
                String string = Pair.of(this.processResponse(response, responseType), (Object)response.getHeaders());
                return string;
            }
            --retryCount;
            try {
                Thread.sleep(retryWaitMillis);
            }
            catch (InterruptedException e) {
                lastException = new RestConnectorException("Error en wait", e);
            }
        }
        throw lastException;
    }

    private <Err> void checkSuccessfulOrException(Response response, Class<Err> errorType) throws RestConnectorException {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Object entityResponseError = null;
            if (errorType != null) {
                try {
                    response.bufferEntity();
                    entityResponseError = response.readEntity(errorType);
                    log.trace("[RestConnector] Entity responseError [" + entityResponseError + "]");
                }
                catch (Exception e) {
                    entityResponseError = response.readEntity(String.class);
                    log.debug("La consulta no tiene tipo[" + errorType.getCanonicalName() + "]");
                }
            } else {
                entityResponseError = response.readEntity(String.class);
            }
            throw new RestConnectorException("La consulta no devolvio OK. Status: [" + response.getStatus() + "/" + response.getStatusInfo() + "]", response.getStatus(), response.getStatusInfo(), entityResponseError);
        }
    }

    private <Res> Res processResponse(Response response, Class<Res> responseType) throws RestConnectorException {
        Object entityResponse;
        if (response.getEntity() == null || responseType == Void.class) {
            entityResponse = null;
            log.trace("[RestConnector] Entity response [vacio]");
        } else {
            try {
                response.bufferEntity();
                entityResponse = response.readEntity(responseType);
                log.trace("[RestConnector] Entity response [" + entityResponse + "]");
            }
            catch (Exception e) {
                String stringResponse = (String)response.readEntity(String.class);
                throw new RestConnectorException("La consulta no tiene tipo[" + responseType.getCanonicalName() + "]. Resultado: [" + stringResponse + "]", e);
            }
        }
        return (Res)entityResponse;
    }

    protected Invocation.Builder buildRequest(String url, Map<String, Object> templateParameters) throws RestConnectorException {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.keyStore != null) {
            builder.keyStore(this.keyStore, this.environment.keyStorePassword);
        }
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        if (this.securityManager != null && this.securityManager.getDisableHTTPSErrors()) {
            SSLContext sslContext = null;
            TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                sslContext = SSLContext.getInstance(SSLSocketFactoryGenerator.defaultProtocol);
                String alg = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmFact = KeyManagerFactory.getInstance(alg);
                kmFact.init(this.keyStore, this.environment.keyStorePassword != null ? this.environment.keyStorePassword.toCharArray() : null);
                KeyManager[] kms = kmFact.getKeyManagers();
                sslContext.init(kms, trustAllCerts, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException alg) {
            }
            catch (KeyStoreException | UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
            builder.sslContext(sslContext);
            builder.hostnameVerifier((hostName, session) -> true);
        }
        WebTarget resource = builder.build().target(url);
        resource.register((Object)this.clientLoggingFilter);
        if (templateParameters != null) {
            resource = resource.resolveTemplates(templateParameters);
        }
        Invocation.Builder request = resource.request();
        return request;
    }

    private KeyStore loadStore(String storePath, String storePassword) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.load(new FileInputStream(storePath), storePassword != null ? storePassword.toCharArray() : null);
        return store;
    }
}

