/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class AliasSelectorKeyManager
implements X509KeyManager {
    private X509KeyManager sourceKeyManager = null;
    private String alias;

    public AliasSelectorKeyManager(X509KeyManager keyManager, String alias) {
        this.sourceKeyManager = keyManager;
        this.alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        boolean aliasFound = false;
        for (int i = 0; i < keyType.length && !aliasFound; ++i) {
            String[] validAliases = this.sourceKeyManager.getClientAliases(keyType[i], issuers);
            if (validAliases == null) continue;
            for (int j = 0; j < validAliases.length && !aliasFound; ++j) {
                if (!validAliases[j].equals(this.alias)) continue;
                aliasFound = true;
            }
        }
        if (aliasFound) {
            return this.alias;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.sourceKeyManager.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.sourceKeyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.sourceKeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.sourceKeyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.sourceKeyManager.getServerAliases(keyType, issuers);
    }
}

