/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ClientFileLoggingFilter;
import ar.com.sdd.commons.rest.log.QueueLogHolder;
import ar.com.sdd.commons.rest.log.QueuedLogWriter;
import ar.com.sdd.commons.rest.log.ServerFileLogginFilter;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueuedLogWriterFileImpl
implements QueuedLogWriter,
Runnable {
    private static final Logger log = LogManager.getLogger(QueuedLogWriterFileImpl.class);
    private static QueuedLogWriterFileImpl instance;
    private final ConcurrentLinkedQueue<QueueLogHolder> queue = new ConcurrentLinkedQueue();
    private boolean doRun;

    public static void initialize() {
        if (instance != null) {
            throw new RuntimeException("QueuedLogWriterFileImpl ya fue inicializado");
        }
        QueuedLogWriterFileImpl.createNewInstance();
    }

    public static void reinitialize() {
        QueuedLogWriterFileImpl.stop();
        QueuedLogWriterFileImpl.createNewInstance();
    }

    private static void createNewInstance() {
        instance = new QueuedLogWriterFileImpl();
        ServerFileLogginFilter.setQueuedLogWriterInstance(instance);
        ClientFileLoggingFilter.setQueuedLogWriterInstance(instance);
        Thread thread = new Thread(instance);
        QueuedLogWriterFileImpl.instance.doRun = true;
        thread.start();
    }

    @Override
    public void add(QueueLogHolder holder) {
        this.queue.add(holder);
    }

    public static void stop() {
        QueuedLogWriterFileImpl.instance.doRun = false;
    }

    @Override
    public void run() {
        while (this.doRun) {
            while (!this.queue.isEmpty()) {
                QueueLogHolder holder = this.queue.poll();
                if (holder == null) continue;
                holder.log();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error("Interrupcion inesperada", (Throwable)e);
            }
        }
    }
}

