package ar.com.sdd.commons.rest.core;

import javax.ws.rs.client.Invocation;

public interface RestSecurityManager {
    //Se invoca para poder configurar los headers para autorizacion
    Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException;

    //Se invoca cada vez que falla una conexion y asi permitir un retry por falla de expiracion de token de autorizacion. Solo se reintena una vez si esto es true
    //Lo normal seria: perdir un nuevo token (que luego se usara en el addHeaders() y retornar true
    boolean retryOnUnauthorized();

    //Indica si ignorar o no los errors por certificado en el server destinto
    boolean getDisableHTTPSErrors();
}
