package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OAuth2SsoCredential implements Serializable {

    public enum OAuth2CredentialAction {
        CREATE_PAYMENT,
        LIST_PAYMENTS,
        BILLER_LOGIN,
    }

    private String payerCuit;
    private String payerCode;
    private String operatorEmail;
    private String operatorName;
    private OAuth2CredentialAction action;
    private String roles;
    private List<CommonParameter> parameters;

    public String getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(String payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getPayerCode() {
        return payerCode;
    }

    public void setPayerCode(String payerCode) {
        this.payerCode = payerCode;
    }

    public String getOperatorEmail() {
        return operatorEmail;
    }

    public void setOperatorEmail(String operatorEmail) {
        this.operatorEmail = operatorEmail;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public OAuth2CredentialAction getAction() {
        return action;
    }

    public void setAction(OAuth2CredentialAction action) {
        this.action = action;
    }

    public String getRoles() {
        return roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public List<CommonParameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<CommonParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String toString() {
        return "OAuth2SsoCredential ["
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((payerCode != null) ? "payerCode=" + payerCode + ", " : "")
                + ((operatorEmail != null) ? "operatorEmail=" + operatorEmail + ", " : "")
                + ((operatorName != null) ? "operatorName=" + operatorName + ", " : "")
                + ((action != null) ? "action=" + action + ", " : "")
                + ((roles != null) ? "roles=" + roles + ", " : "")
                + ((parameters != null) ? "parameters=" + Arrays.toString(parameters.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OAuth2SsoCredential that = (OAuth2SsoCredential) o;

        if (payerCuit != null ? !payerCuit.equals(that.payerCuit) : that.payerCuit != null) return false;
        if (payerCode != null ? !payerCode.equals(that.payerCode) : that.payerCode != null) return false;
        if (operatorEmail != null ? !operatorEmail.equals(that.operatorEmail) : that.operatorEmail != null) return false;
        if (operatorName != null ? !operatorName.equals(that.operatorName) : that.operatorName != null) return false;
        if (action != that.action) return false;
        if (roles != null ? !roles.equals(that.roles) : that.roles != null) return false;
        return parameters != null ? parameters.equals(that.parameters) : that.parameters == null;
    }

    @Override
    public int hashCode() {
        int result = payerCuit != null ? payerCuit.hashCode() : 0;
        result = 31 * result + (payerCode != null ? payerCode.hashCode() : 0);
        result = 31 * result + (operatorEmail != null ? operatorEmail.hashCode() : 0);
        result = 31 * result + (operatorName != null ? operatorName.hashCode() : 0);
        result = 31 * result + (action != null ? action.hashCode() : 0);
        result = 31 * result + (roles != null ? roles.hashCode() : 0);
        result = 31 * result + (parameters != null ? parameters.hashCode() : 0);
        return result;
    }
}
