/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import ar.com.sdd.commons.rest.util.AliasSelectorKeyManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactoryGenerator {
    public static String defaultProtocol = "TLSv1.2";
    private String alias = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;

    public SSLSocketFactoryGenerator(String alias, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias may not be null");
        }
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    public SSLSocketFactoryGenerator(String alias, String keyStore, String keyStorePassword) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias may not be null");
        }
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = keyStore;
        this.trustStorePassword = keyStorePassword;
    }

    public SSLSocketFactoryGenerator(String alias, String keyStore, String keyStorePassword, boolean userNullTrustore) {
        if (alias == null) {
            throw new IllegalArgumentException("The alias may not be null");
        }
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        if (userNullTrustore) {
            this.trustStore = null;
            this.trustStorePassword = null;
        } else {
            this.trustStore = this.trustStore;
            this.trustStorePassword = this.trustStorePassword;
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException, GeneralSecurityException {
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasSelectorKeyManager((X509KeyManager)keyManagers[i], this.alias);
        }
        SSLContext context = SSLContext.getInstance(defaultProtocol);
        context.init(keyManagers, trustManagers, new SecureRandom());
        SSLSocketFactory ssf = context.getSocketFactory();
        return ssf;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    private KeyManager[] getKeyManagers() throws IOException, GeneralSecurityException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmFact = KeyManagerFactory.getInstance(alg);
        FileInputStream fis = new FileInputStream(this.getKeyStore());
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(fis, this.getKeyStorePassword().toCharArray());
        fis.close();
        kmFact.init(ks, this.getKeyStorePassword().toCharArray());
        KeyManager[] kms = kmFact.getKeyManagers();
        return kms;
    }

    protected TrustManager[] getTrustManagers() throws IOException, GeneralSecurityException {
        if (this.trustStore == null) {
            TrustManager[] tms = new TrustManager[]{new MyTrustManager()};
            return tms;
        }
        String alg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmFact = TrustManagerFactory.getInstance(alg);
        FileInputStream fis = new FileInputStream(this.getTrustStore());
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(fis, this.getTrustStorePassword().toCharArray());
        fis.close();
        tmFact.init(ks);
        return tmFact.getTrustManagers();
    }

    public static class MyTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

