/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.util;

import ar.com.sdd.commons.rest.util.RFC3339DateFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.text.DateFormat;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

@Provider
public class RestMapperBuilder
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper objectMapper = RestMapperBuilder.getObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return new ObjectMapper().setDateFormat((DateFormat)((Object)new RFC3339DateFormat())).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).registerModule((Module)new JodaModule(){
            {
                this.addSerializer(DateTime.class, (JsonSerializer)new StdSerializer<DateTime>(DateTime.class){

                    public void serialize(DateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                        jgen.writeString(ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)value));
                    }
                });
                this.addSerializer(LocalDate.class, (JsonSerializer)new StdSerializer<LocalDate>(LocalDate.class){

                    public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
                        jgen.writeString(ISODateTimeFormat.date().print((ReadablePartial)value));
                    }
                });
            }
        });
    }
}

