package ar.com.sdd.commons.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ErrorResult implements Serializable {

    private String trackingCode;
    private String description;
    private Object referencedEntity;

    public ErrorResult() {
    }

    public ErrorResult(String trackingCode, String description) {
        this.trackingCode = trackingCode;
        this.description = description;
    }

    public ErrorResult(String trackingCode, String description, Object referencedEntity) {
        this.trackingCode = trackingCode;
        this.description = description;
        this.referencedEntity = referencedEntity;
    }

    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getReferencedEntity() {
        return referencedEntity;
    }

    public void setReferencedEntity(Object referencedEntity) {
        this.referencedEntity = referencedEntity;
    }

    @Override
    public String toString() {
        return "ErrorResult [" +
                ((trackingCode != null) ? "trackingCode='" + trackingCode + "', " : "") +
                ((description != null) ? "description='" + description + "', " : "") +
                ((referencedEntity != null) ? "referencedEntity=" + referencedEntity + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErrorResult that = (ErrorResult) o;
        return Objects.equals(trackingCode, that.trackingCode) && Objects.equals(description, that.description) && Objects.equals(referencedEntity, that.referencedEntity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trackingCode, description, referencedEntity);
    }
}