package ar.com.sdd.commons.rest.util;

import javax.net.ssl.*;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

/*
* Un SSL socket manager general, que permite usar un trustore con un alias especifico para el autenticacion
* No esta del todo bien que este en este package, deeria estar en algo mas genral, porque podria usarse para conexiones
* SSL en general, no solo para casos REST
* Pero a falta de una liberaria comun, mejor aca que en otro lado
*
* El uso basico es:
*
*  SSLSocketFactory socketFactory = new SSLSocketFactoryGenerator("nombre.del.certificado.com", "path/to/keystore.jks", "pass del keystore y de la key").getSSLSocketFactory();
*  HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
*
* Por ahora
*   - solo soporta formato de keystore JKS
*   - se le peude para un keystore unico para el kestore y trustore, o dos por separado
*
* */
public class SSLSocketFactoryGenerator {

    public static String defaultProtocol = "TLSv1.2" ; //como para poder cambiarlo alguna vez
    private String alias = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;

    //Variante: usando keystore y trusttore
    public SSLSocketFactoryGenerator (String alias, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        if (alias == null)
            throw new IllegalArgumentException("The alias may not be null");
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    //Variante: usando keystore con las keys del trusttore en el mismo keystore
    public SSLSocketFactoryGenerator (String alias, String keyStore, String keyStorePassword) {
        if (alias == null)
            throw new IllegalArgumentException("The alias may not be null");
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = keyStore;
        this.trustStorePassword = keyStorePassword;
    }

    //Variante: usando keystore y forzando un trustore con 'acceptAll'
    public SSLSocketFactoryGenerator (String alias, String keyStore, String keyStorePassword, boolean userNullTrustore) {
        if (alias == null)
            throw new IllegalArgumentException("The alias may not be null");
        this.alias = alias;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        if (userNullTrustore) {
            this.trustStore = null;
            this.trustStorePassword = null;
        } else {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
        }
    }




    public SSLSocketFactory getSSLSocketFactory() throws IOException, GeneralSecurityException {

        KeyManager[] keyManagers = getKeyManagers();
        TrustManager[] trustManagers =getTrustManagers();


        //For each key manager, check if it is a X509KeyManager (because we will override its       //functionality
        for (int i=0; i<keyManagers.length; i++) {
            if (keyManagers[i] instanceof X509KeyManager) {
                keyManagers[i]=new AliasSelectorKeyManager((X509KeyManager)keyManagers[i], alias);
            }
        }


        SSLContext context=SSLContext.getInstance(defaultProtocol); //Antes era SSL
        context.init(keyManagers, trustManagers, new SecureRandom());



        SSLSocketFactory ssf=context.getSocketFactory();
        return ssf;
    }


    public String getKeyStorePassword() {
        return keyStorePassword;
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }


    public String getKeyStore() {
        return keyStore;
    }

    public String getTrustStore() {

        return trustStore;
    }


    private KeyManager[] getKeyManagers()
            throws IOException, GeneralSecurityException
    {

        //Init a key store with the given file.

        String alg=KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmFact=KeyManagerFactory.getInstance(alg);


        FileInputStream fis=new FileInputStream(getKeyStore());
        KeyStore ks=KeyStore.getInstance("jks");
        ks.load(fis, getKeyStorePassword().toCharArray());
        fis.close();

        //Init the key manager factory with the loaded key store
        kmFact.init(ks,  getKeyStorePassword().toCharArray());



        KeyManager[] kms=kmFact.getKeyManagers();
        return kms;
    }


    public static class MyTrustManager implements X509TrustManager{
        public MyTrustManager() {}
        public void checkClientTrusted(X509Certificate[] chain, String authType)  {    }
        public void checkServerTrusted(X509Certificate[] chain, String authType) {    }
        public X509Certificate[] getAcceptedIssuers()
        {        return null;    }
    }

    protected TrustManager[] getTrustManagers() throws IOException, GeneralSecurityException
    {
        if (trustStore==null) {
            TrustManager[] tms= { new MyTrustManager() };
            return  tms;
        } else {
            String alg = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmFact = TrustManagerFactory.getInstance(alg);


            FileInputStream fis = new FileInputStream(getTrustStore());
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(fis, getTrustStorePassword().toCharArray());
            fis.close();
            tmFact.init(ks);
            return tmFact.getTrustManagers();
        }
    }
}