package ar.com.sdd.commons.rest.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.concurrent.ConcurrentLinkedQueue;

public class QueuedLogWriterFileImpl implements QueuedLogWriter, Runnable {

    private static final Logger log = LogManager.getLogger(QueuedLogWriterFileImpl.class);

    private static QueuedLogWriterFileImpl instance;
    private final ConcurrentLinkedQueue<QueueLogHolder> queue;
    private boolean doRun;


    public  QueuedLogWriterFileImpl() {
        queue = new ConcurrentLinkedQueue<>();
    }

    public static void initialize() {
        if (instance != null) {
            //Antes tiraba una excepcion. Vamos mejor a ignorar solo dejando un log
            log.error("QueuedLogWriterFileImpl ya fue inicializado");
            return;

        }
        createNewInstance();
    }

    public static void reinitialize() {
        stop();
        createNewInstance();
    }

    private static void createNewInstance() {
        instance = new QueuedLogWriterFileImpl();
        ServerFileLogginFilter.setQueuedLogWriterInstance(instance);
        ClientFileLoggingFilter.setQueuedLogWriterInstance(instance);
        Thread thread = new Thread(instance);
        instance.doRun = true;
        thread.start();
    }

    @Override
    public void add(QueueLogHolder holder) {
        queue.add(holder);
    }

    public static void stop() {
        instance.doRun = false;
    }

    @Override
    public void run() {
        while(doRun) {

            while(!queue.isEmpty()) {
                QueueLogHolder holder = queue.poll();
                if (holder != null) {
                    holder.log();
                }
            }

            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                log.error("Interrupcion inesperada", e);
            }
        }
    }


}
