package ar.com.sdd.commons.rest.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

@ServerLogged
@Provider
public class ServerLogginFilter implements ContainerRequestFilter, ContainerResponseFilter {

    private static final Logger log = Logger.getLogger(ServerLogginFilter.class);

    /**
     * Request filter
     *
     * @param requestContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy(requestContext.getEntityStream(), baos);
        byte[] bytes = baos.toByteArray();
        log.info("[RestConnector] Server Request - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:" + new String(bytes, "UTF-8"));
        requestContext.setEntityStream(new ByteArrayInputStream(bytes));
    }

    /**
     * Response filter
     *
     * @param requestContext
     * @param responseContext
     * @throws IOException
     */
    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity != null) {
            log.info("[RestConnector] Server Response - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]:" + new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(entity));
        } else {
            log.info("[RestConnector] Server Response:(vacio)");
        }
    }
}
