/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@Priority(value=-2147483648)
public class ClientLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final Logger log = Logger.getLogger(ClientLoggingFilter.class);
    private static final Logger logAll = Logger.getLogger((String)"ar.com.sdd.commons.rest.log.LogAll");
    private static final String ENTITY_STREAM_PROPERTY = "ClientLoggingFilter.entityStream";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final int maxEntitySize = 8192;

    public void filter(ClientRequestContext requestContext) {
        if (requestContext.hasEntity()) {
            LoggingStream stream = new LoggingStream(requestContext.getEntityStream(), requestContext.getUri(), requestContext.getMethod());
            requestContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_STREAM_PROPERTY, (Object)stream);
        } else {
            StringBuilder sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
            String uri = requestContext.getUri() != null ? requestContext.getUri().toString() : "N/A";
            String method = requestContext.getMethod() != null ? requestContext.getMethod() : "N/A";
            sb.append("[RestConnector] Client Request - Method [").append(method).append("], URI [").append(uri).append("]:NO_ENTITY");
            log.info((Object)sb);
            logAll.trace((Object)sb);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LoggingStream stream = (LoggingStream)context.getProperty(ENTITY_STREAM_PROPERTY);
        context.proceed();
        if (stream != null) {
            stream.logStream();
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        boolean chunked;
        StringBuilder sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
        boolean bl = chunked = responseContext.getHeaders() != null && responseContext.getHeaderString("Transfer-Encoding") != null && responseContext.getHeaderString("Transfer-Encoding").equalsIgnoreCase("chunked");
        if (responseContext.hasEntity()) {
            responseContext.setEntityStream(this.logInboundEntity(responseContext.getStatusInfo(), responseContext.getEntityStream(), chunked));
        } else {
            String statusCode = responseContext.getStatusInfo() != null ? String.valueOf(responseContext.getStatusInfo().getStatusCode()) : "N/A";
            sb.append("[RestConnector] Client Response - Status [").append(statusCode).append("]:NO_ENTITY");
        }
        log.info((Object)sb);
        logAll.trace((Object)sb);
    }

    private InputStream logInboundEntity(Response.StatusType statusInfo, InputStream stream, boolean chunked) throws IOException {
        String result = IOUtils.toString((InputStream)stream, (Charset)DEFAULT_CHARSET);
        StringBuilder sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
        sb.append("[RestConnector] Client Response - Status [").append(statusInfo.getStatusCode()).append("]:");
        if (chunked) {
            sb.append("[chunked]");
            log.info((Object)sb);
            logAll.trace((Object)sb);
        } else {
            if (result.length() > 8192) {
                log.info((Object)(sb.substring(0, 8192) + "...more..."));
            } else {
                log.info((Object)sb);
            }
            logAll.trace((Object)sb);
        }
        stream.reset();
        return stream;
    }

    private class LoggingStream
    extends FilterOutputStream {
        private final StringBuilder sb;
        private final ByteArrayOutputStream baos;
        private URI uri;
        private String method;

        LoggingStream(OutputStream out, URI uri, String method) {
            super(out);
            this.sb = new StringBuilder("[" + RestConnectorUtil.getCacheSafeValue() + "]:");
            this.baos = new ByteArrayOutputStream();
            this.uri = uri;
            this.method = method;
        }

        void logStream() {
            byte[] entity = this.baos.toByteArray();
            this.sb.append("[RestConnector] Client Request - Method [").append(this.method).append("], URI [").append(this.uri).append("]:");
            this.sb.append(new String(entity, 0, entity.length, DEFAULT_CHARSET));
            logAll.trace((Object)this.sb);
            if (entity.length > 8192) {
                log.info((Object)(this.sb.substring(0, 8192) + "...more..."));
            } else {
                log.info((Object)this.sb);
            }
        }

        @Override
        public void write(int i) throws IOException {
            this.baos.write(i);
            this.out.write(i);
        }
    }
}

