/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.commons.rest.log;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.Logger;

@ServerFileLogged
@Provider
public class ServerFileLogginFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerFileLogginFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)baos);
        String timestamp36 = RestConnectorUtil.getCacheSafeValue();
        requestContext.setProperty("timestamp36", (Object)timestamp36);
        String respuesta = "[" + timestamp36 + "]:[RestConnector] Server Request - Method [" + requestContext.getMethod() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]";
        String bearer = requestContext.getHeaderString("Bearer");
        if (!StringUtils.isEmpty((CharSequence)bearer)) {
            requestContext.setProperty("bearer", (Object)bearer);
            respuesta = respuesta + ", Bearer [" + bearer + "]";
        }
        File logFile = this.getLogFile(timestamp36, "request");
        log.info((Object)(respuesta + ", logFile [" + logFile + "]"));
        byte[] bytes = baos.toByteArray();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(logFile));){
            bos.write((respuesta + "\n").getBytes(StandardCharsets.UTF_8));
            bos.write(bytes);
        }
        catch (Exception e) {
            log.error((Object)("[" + timestamp36 + "] No se pudo escribir el archivo de log [" + logFile + "]"), (Throwable)e);
        }
        requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity;
        String timestamp36 = (String)requestContext.getProperty("timestamp36");
        if (StringUtils.isEmpty((CharSequence)timestamp36)) {
            timestamp36 = RestConnectorUtil.getCacheSafeValue();
            log.warn((Object)("No se pudo recuperar el timestamp36, se computa uno nuevo [" + timestamp36 + "]"));
        }
        String respuesta = "[" + timestamp36 + "]:[RestConnector] Server Response - Method [" + requestContext.getMethod() + "], Status [" + responseContext.getStatus() + "], URI [" + requestContext.getUriInfo().getRequestUri() + "]";
        String bearer = (String)requestContext.getProperty("bearer");
        if (!StringUtils.isEmpty((CharSequence)bearer)) {
            respuesta = respuesta + ", Bearer [" + bearer + "]";
        }
        if ((entity = responseContext.getEntity()) != null) {
            File logFile = this.getLogFile(timestamp36, "response");
            log.info((Object)(respuesta + ", logFile [" + logFile + "]"));
            try (PrintWriter logFileWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(logFile)));){
                logFileWriter.write(respuesta + "\n");
                new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)logFileWriter, entity);
            }
            catch (Exception e) {
                log.error((Object)("[" + timestamp36 + "] No se pudo escribir el archivo de log [" + logFile + "]"), (Throwable)e);
            }
        } else {
            log.info((Object)(respuesta + "(vacio)"));
        }
    }

    private File getLogFile(String timestamp36, String requestResponseTag) throws IOException {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd-HHmmss-SSS");
        String logFilename = "restconnector_server_" + date + "_" + requestResponseTag + "_" + timestamp36 + ".log";
        return new File(FilenameUtils.concat((String)this.getLogDirectory(), (String)logFilename));
    }

    private String getLogDirectory() throws IOException {
        boolean result;
        String jbossLogDir = System.getProperty("jboss.server.log.dir");
        Path path = Paths.get(jbossLogDir, "io");
        File logDirectory = new File(path.toUri());
        if (!logDirectory.exists() && !(result = logDirectory.mkdirs())) {
            throw new IOException("No se pudo crear el directorio de log [" + logDirectory + "]");
        }
        return logDirectory.getAbsolutePath();
    }
}

