package ar.com.sdd.commons.util;


/**
 * Parseador de numeros para Java
 * @author eviera@sdd
 */
public class NumberParser {

	String signo;
	String parteEntera;
	String parteDecimal;

	//Constructores

	public NumberParser (float num, int numBase) {
		this((double)num,numBase);
	}

	public NumberParser (double num, int numBase) {

		boolean signoMenos;
		long cents;
		long numInt;

		signoMenos = (num < 0 ) ? true : false;
		numInt = (num > 0) ? (long)(Math.floor(num * numBase + 0.50000000001)) : (long)(Math.ceil(num * numBase - 0.50000000001));
		cents = Math.abs(numInt % numBase);
		numInt = numInt / numBase; 
		if (numInt == 0 && cents == 0) signoMenos = false;
		String numStr = Long.toString(numInt);
		String centsStr = Long.toString(cents);
		if (cents < (numBase / 10)) centsStr = "0" + centsStr; 	

		if (signoMenos && numInt != 0) numStr = numStr.substring(1,numStr.length());

		this.signo = (signoMenos) ? "-" : "";	
		this.parteEntera = this.signo + numStr;		
		this.parteDecimal = centsStr;
	}

	public String getSigno() {
		return this.signo;
	}

	public String getParteEntera() {
		return this.parteEntera;
	}

	public String getParteDecimal() {
		return this.parteDecimal;
	}

	public String format() {
		//Deberian obtenerse del Locale
		//String decSep = "."; 
		//String thousandSep = ","; 	
		/*
		* Codigo en javascript... pasar a Java
		
		for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++) 
			num = num.substring(0, num.length - (4 * i + 3)) + thousandSep + num.substring(num.length - (4 * i + 3)); 
		
		this.format = function() {
			if (numBase == 1) 
				return (this.signo + num); 
			else 
				return (this.signo + num + decSep + cents); 
		}
		*/
		return "";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((parteDecimal == null) ? 0 : parteDecimal.hashCode());
		result = prime * result + ((parteEntera == null) ? 0 : parteEntera.hashCode());
		result = prime * result + ((signo == null) ? 0 : signo.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NumberParser other = (NumberParser) obj;
		if (parteDecimal == null) {
			if (other.parteDecimal != null)
				return false;
		} else if (!parteDecimal.equals(other.parteDecimal))
			return false;
		if (parteEntera == null) {
			if (other.parteEntera != null)
				return false;
		} else if (!parteEntera.equals(other.parteEntera))
			return false;
		if (signo == null) {
			if (other.signo != null)
				return false;
		} else if (!signo.equals(other.signo))
			return false;
		return true;
	}


}