package ar.com.sdd.commons.util;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * <p>Permite hacer un <i>toString()</i> de un objeto primitivo o no de Java y devolverlo en formato JSON</p>
 * <p>Para utilizarlo:</p>
 * <code>ReflectionToStringBuilder.toString(&lt;object&gt;, new RecursiveJsonToStringStyle())</code>
 *
 * @author Javier Alejandro Giani
 */
public class RecursiveJsonToStringStyle extends RecursiveToStringStyle {

	private static final Logger log = LogManager.getLogger(RecursiveJsonToStringStyle.class);

	public RecursiveJsonToStringStyle() {
		super();

		super.setUseClassName(false);
		super.setUseIdentityHashCode(false);

		super.setContentStart("{");
		super.setContentEnd("}");

		super.setArrayStart("[");
		super.setArrayEnd("]");

		super.setFieldSeparator(",");
		super.setFieldNameValueSeparator(":");

		super.setNullText("null");

		super.setSummaryObjectStartText("\"<");
		super.setSummaryObjectEndText(">\"");

		super.setSizeStartText("\"<size=");
		super.setSizeEndText(">\"");
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, Object[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, long[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, int[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, short[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, byte[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, char[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, double[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, float[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, boolean[] array, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, array, fullDetail);
	}

	@Override
	public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}
		if (!isFullDetail(fullDetail)) {
			log.error("FullDetail must be true when using JsonToStringStyle");
			return;
		}

		super.append(buffer, fieldName, value, fullDetail);
	}

	@Override
	public void appendDetail(StringBuffer buffer, String fieldName, Object value) {
		if (value == null) {
			appendNullText(buffer, fieldName);
			return;
		}

		if (!ClassUtils.isPrimitiveWrapper(value.getClass()) && !String.class.equals(value.getClass())) {
			buffer.append(ReflectionToStringBuilder.toString(value, this));
		} else {
			if (value.getClass() == String.class) {
				appendValueAsString(buffer, (String)value);
				return;
			}

			buffer.append(value);
		}
	}

	/**
	 * Appends the given String in parenthesis to the given StringBuffer.
	 *
	 * @param buffer the StringBuffer to append the value to.
	 * @param value the value to append.
	 */
	private void appendValueAsString(StringBuffer buffer, String value) {
		buffer.append("\"").append(value).append("\"");
	}

	@Override
	protected void appendFieldStart(StringBuffer buffer, String fieldName) {
		if (fieldName == null) {
			log.error("Field names are mandatory when using JsonToStringStyle");
			return;
		}

		super.appendFieldStart(buffer, "\"" + fieldName + "\"");
	}

	/**
	 * <p>
	 * Ensure <code>Singleton</code> after serialization.
	 * </p>
	 *
	 * @return the singleton
	 */
	private Object readResolve() {
		return ToStringStyle.JSON_STYLE;
	}
}
