package ar.com.sdd.commons.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * Timer para profiling de codigo Java.
 */
public class TimerUtil {

	private final static Logger log= LogManager.getLogger(TimerUtil.class);

	private long timeStart;

	private Level level;

	private Map<String, TimerUtil> times = new HashMap<>();
	
	public TimerUtil() {
		this.timeStart = System.currentTimeMillis();
	}

	public TimerUtil(Level level) {
		this.timeStart = System.currentTimeMillis();
		this.level = level;
	}	

	public void start(String key) {
		times.put(key, new TimerUtil());
	}
	
	public void stopAndLog(String key) {
		TimerUtil timer = times.get(key);
		
		String logString = "Tiempo transcurrido para " + key + "=" + timer.timerElapsed() + "ms";
		
		//FIXME habria que decirle a log que loguee en el nivel correcto
		if (level.equals(Level.DEBUG)) {
			log.debug(logString);
		} else if (level.equals(Level.TRACE)) {
			log.trace(logString);
		} else if (level.equals(Level.INFO)) {
			log.info(logString);
		} else {
			log.error("Level invalido:" + level);
		}
		
		times.remove(key);
	}
	
	public void timerStart() { 
		this.timeStart = System.currentTimeMillis(); 
	}
	
	public long timerElapsed() {
		return System.currentTimeMillis() - timeStart; 
	}
	
	public void showTimestamp(String label) {
		//if ( log.isDebugEnabled() )
		//	log.debug("@PROFILE [" + label + "]. Time [" + timerElapsed()/1000.0 + "] "
		//		+ "mem [" + Runtime.getRuntime().freeMemory() / 1000.0 + "K]");
	}
}