package ar.com.sdd.commons.util;

/**
 * Clase pare representar el concepto de tupla o par (x;y)  Pueden ser ambos null
 * El lado izquierdo, o componente x, se denomina 'first'
 * El lado derecho, o componente y, se denomina 'second'
 *
 * @param <T>
 * @param <U>
 */
public class Tuple<T, U> {
	private T first;
	private U second;
	private transient final int hash;

	public Tuple(T first, U second) {
		this.first = first;
		this.second = second;
		hash = (first == null ? 0 : first.hashCode() * 31) + (second == null ? 0 : second.hashCode());
	}

	public T getFirst() {
		return first;
	}

	public Tuple<T, U> setFirst(T first) {
		this.first = first;
		return this;
	}

	public U getSecond() {
		return second;
	}
	public Tuple<T, U> setSecond(U second) {
		this.second = second;
		return this;
	}

	@Override
	public int hashCode() {
		return hash;
	}

	@Override
	public String toString() {
		return "(" + (getFirst() == null ? "null" : getFirst().toString()) + "; " + (getSecond() == null ? "null" : getSecond().toString()) + ")";
	}
	
	@Override
	public boolean equals(Object oth) {
		if (this == oth) {
			return true;
		}
		if (oth == null || !(getClass().isInstance(oth))) {
			return false;
		}
		@SuppressWarnings("unchecked")
		Tuple<T, U> other = getClass().cast(oth);
		return (first == null ? other.first == null : first.equals(other.first))
				&& (second == null ? other.second == null : second.equals(other.second));
	}

}