package ar.com.sdd.commons.util.converter;

import java.math.BigDecimal;

public class BigDecimalToLongConverter implements DataConverter {

   static BigDecimalToLongConverter instancia = null;

   public BigDecimalToLongConverter() {}

   protected static BigDecimalToLongConverter getInstance() {
      if (instancia == null) {
         instancia = new BigDecimalToLongConverter();
      }
      return instancia;
   }

   public static Long convertTo(BigDecimal o) {
      return (Long)getInstance().convertDataTo(o);
   }

   public static BigDecimal convertFrom(Long o) {
      return (BigDecimal)getInstance().convertFromData(o);
   }


//--- Implementacion de DataConverter ------------------------------------------------------------------------

    public Object convertDataTo(Object o) {
        return ( o != null ? Long.valueOf(((BigDecimal)o).longValue()) : null);
    }

    public Object convertFromData(Object o) {
        return ( o != null ? new BigDecimal(((Long)o).longValue()) : null);
    }


}




