package ar.com.sdd.commons.util.converter;

import java.sql.Timestamp;
import java.util.Date;


/**
 * Convierte entre java.util.Date y java.sql.Timestamp.
 */
public class DateToTimestampConverter implements DataConverter {

	static DateToTimestampConverter instancia = null;


	//-----------------------------------------------------------------------------//
		
	public DateToTimestampConverter() {}
	
	
	protected static DateToTimestampConverter getInstance() {
		if (instancia == null) instancia = new DateToTimestampConverter();
		return instancia;
	}

	
	public static Timestamp convertTo(Date o) {
		return (Timestamp)getInstance().convertDataTo(o);
	}
	
	
	public static Date convertFrom(Timestamp o) {
		return (Date)getInstance().convertFromData(o);
	}
	
	
	public Object convertDataTo(Object o) {

		if (o == null) return null;
	
		if (!(o instanceof Date))
			throw new IllegalArgumentException("El objeto no es Date");
	
		return new Timestamp(((Date) o).getTime());
	}
	
	
	public Object convertFromData(Object o) {
		
		if (o == null) return null;
	
		if (!(o instanceof Timestamp) &&  !(o instanceof Date)) {
			throw new IllegalArgumentException("El objeto a convertir no es Timestamp: "
											 + "[" + o + "]");
		}
		if(o instanceof Timestamp){
			o = new Date( ((Timestamp)o).getTime());
		}
		
		return o;
	}

}
