package ar.com.sdd.commons.util.converter;

import ar.com.sdd.commons.util.audit.Auditable;

public class ObjectToAuditableConverter implements DataConverter {

   static ObjectToAuditableConverter instancia = null;

   public ObjectToAuditableConverter() {}

   protected static ObjectToAuditableConverter getInstance() {
      if (instancia == null) {
         instancia = new ObjectToAuditableConverter();
      }
      return instancia;
   }

   public static Auditable convertTo(Object o) {
      return (Auditable)getInstance().convertDataTo(o);
   }

   public static Object convertFrom(Auditable o) {
      return (Object)getInstance().convertFromData(o);
   }


//--- Implementacion de DataConverter ------------------------------------------------------------------------

    public Object convertDataTo(Object o) {
        return ( o != null ? new AuditableWrapper(o) : null);
    }

    public Object convertFromData(Object o) {
        return ( o != null ? ((AuditableWrapper)o).getObject() : null);
    }


    class AuditableWrapper implements Auditable{
        private Object object = null;

        public AuditableWrapper(Object o ){
          object = o;
        }

	    public Object getAuditFieldValue(int index){
          return object.toString();
        }

        public Object getObject(){
          return object;
        }
    }
}




