package ar.com.sdd.commons.util.converter;

import ar.com.sdd.commons.util.SynchronizedSimpleDateFormat;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;

public class StringToTimestampConverter implements DataConverter {

   static StringToTimestampConverter instancia = null;
   static final SynchronizedSimpleDateFormat formater = new SynchronizedSimpleDateFormat("dd/M/yyyy hh:mm:ss");

   public StringToTimestampConverter() {}

   protected static StringToTimestampConverter getInstance() {
      if (instancia == null) {
         instancia = new StringToTimestampConverter();
      }
      return instancia;
   }

   public static Timestamp convertTo(String o) {
      return (Timestamp)getInstance().convertDataTo(o);
   }

   public static String convertFrom(java.util.Date o) {
	      return (String)getInstance().convertFromData(o);
   }

   public static String convertFrom(Timestamp o) {
	      return (String)getInstance().convertFromData(o);
	   }
	   
   public Object convertDataTo(Object o) {
      if (o == null) {
         return null;
      }
      if (! (o instanceof String) ) {
         throw new IllegalArgumentException("El objeto no es String");
      }

      Timestamp ts = null;
      try {
   		  ts = new Timestamp(formater.parse((String)o).getTime());
      } catch (ParseException ex) {
         throw new IllegalArgumentException("Formato del string invalido: [" + ex.getMessage() + "]");
      }
      return ts;
   }

   public Object convertFromData(Object o) {
      if (o == null) {
         return "";
      }
      if (o instanceof Timestamp) {
    	  Timestamp ts = (Timestamp)o;
       	  return formater.format(new Date(ts.getTime()));  
      } else if (o instanceof java.util.Date) {
    	  java.util.Date d = (java.util.Date)o;
       	  return formater.format(d);
      } else {
         throw new IllegalArgumentException("El objeto a convertir no es un tipo permitido: [" + o + "]");
      }

      
   }


}