package ar.com.sdd.commons.util.db;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class CriteriaBuilder implements Serializable {

	static Logger log = LogManager.getLogger(CriteriaBuilder.class);

    //Esto permite mapear expresiones con o sin like (%) separadas por pipe
    //  ej
    //      A  =>   field = A
    //     A|B =>   field = A or field = B
    //    %A|B =>   field like %A or field = B
    //     null =>  null
    public static Criterion  createForLikeInList(String field, Collection<String> expresion) {
        if (CollectionUtils.isEmpty(expresion))
            return null;
        ArrayList<Criterion> orExpressions = new ArrayList<>();
        for (String tag:expresion) {
            tag = tag.trim(); //saco espacios
            //Uso un modelo 'comodo' para decidir como buscar.
            MatchMode matchMode = MatchMode.ANYWHERE;
            boolean anyLike = false;
            if (tag.charAt(0) == '%') {
                tag = tag.substring(1);
                matchMode = MatchMode.END;
                anyLike = true;
            }
            if (tag.endsWith("%")) {
                tag = tag.substring(0, tag.length() - 1);
                matchMode = matchMode.equals(MatchMode.END)?MatchMode.ANYWHERE:MatchMode.START;
                anyLike = true;
            }
            if (anyLike) {
                orExpressions.add(Restrictions.ilike(field, tag, matchMode));
            } else {
                orExpressions.add(Restrictions.eq(field, tag));
            }
        }
        if (orExpressions.size()==1) {
            return orExpressions.get(0);
        } else if (orExpressions.size()>1) {
            return Restrictions.or(orExpressions.toArray(new Criterion[0]));
        } else return null;
    }

}
