package ar.com.sdd.commons.util.file;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * Filtro para nombres de archivo. 
 * IMPORTANTE: es case-sensitive.
 *
 * @author Andres Ferrari
 */
public class FileNameFilter implements FilenameFilter {
	
	private Collection conditions;

	//-----------------------------------------------------------------------------//

	/**
	 * Crea un filtro de nombres de archivo. Recibe las condiciones para
	 * aceptar y/o rechazar archivos
	 */
	public FileNameFilter(Collection conditions) {
		this.conditions = conditions;
	}


	/**
	 * Implementacion del metodo de FilenameFilter.
	 */
	public boolean accept(File dir, String name) {

		boolean acceptFile = true;

		// Para las opciones de aceptacion, en caso de que las haya
		int options 		= 0;
		int optionsAccepted = 0;

		// Se fija que cumpla todas las condiciones de aceptacion y/o rechazo.
		if (conditions != null) {

			Iterator itConditions = conditions.iterator();
			while (itConditions.hasNext() && acceptFile) {

				FilterCondition condition = (FilterCondition) itConditions.next();
				int matchType    		  = condition.getMatchType();
				String filterString 	  = condition.getFilterString();
                String nameToMatch        = name;
                if (condition.getIgnoreCase()) {
                    nameToMatch        = nameToMatch.toUpperCase();
                    filterString       = filterString.toUpperCase();
                }

				if (matchType == FilterCondition.MATCH_START) {

					acceptFile = nameToMatch.startsWith(filterString);

				} else if (matchType == FilterCondition.MATCH_END) {

					acceptFile = nameToMatch.endsWith(filterString);

				} else if (matchType == FilterCondition.MATCH_CONTAINS) {
					// El match se hace con el nombre no con la extension!!!!!
					// recibe un filtro comun D.O.S.

						//armo filtros regular expresion, Escapeo el . y ademas reemplazo: * por .*  ? por .
						String charInPto = "\\.";

						String charOutPtoRE = "\\[\\.\\]";

						String charInAster = "\\*";

						String charOutPtoAster = "\\.\\*";

						String charsProhibidos = "(\\.\\.)/";

						filterString = filterString.replaceAll(charInPto, charOutPtoRE);

						filterString = filterString.replaceAll(charInAster, charOutPtoAster);

						filterString = filterString.replaceAll(charsProhibidos, charOutPtoAster);

						String charInPreg = "\\?";

						String charOutPto = "\\.\\?";

						filterString = filterString.replaceAll(charInPreg, charOutPto);

						Pattern Patron= Pattern.compile(filterString);

						Matcher M= Patron.matcher(nameToMatch);

						acceptFile = M.matches();

				}					
				 else if (matchType == FilterCondition.MATCH_CONTAINS_RE) {
					//recibe un filtro expresion regular
					Pattern Patron= Pattern.compile(filterString);

					Matcher M= Patron.matcher(nameToMatch);

					acceptFile = M.matches();
				}					
					
				/*else if (matchType == FilterCondition.MATCH_CONTAINS) {
//					acceptFile = (nameToMatch.indexOf(filterString) != -1); 
					Pattern Patron= Pattern.compile(filterString);
					Matcher M= Patron.matcher(nameToMatch);
					acceptFile = M.matches();
				}*/



				if (condition instanceof FilterRejectCondition) {

					// Si es una condicion de rechazo, niega el valor de acceptFile
					acceptFile = !acceptFile;

				} else if (condition instanceof FilterOptionCondition) {

					// Si es una condicion opcional, incrementa en 1 las opciones procesadas.
					// Ademas, si acepto la opcion incrementa las opciones ACEPTADAS.
					options++;
					if (acceptFile) optionsAccepted++;

					// Fuerzo acceptFile a true porque una opcion rechazada no necesariamente
					// rechaza el archivo (siempre puedo aceptar otra de las opciones)
					acceptFile = true;

				}

			}
		}

		// Si habia opciones pero no se acepto ninguna, rechaza el archivo
		if (options > 0 && optionsAccepted == 0) acceptFile = false;

		return acceptFile;
	}

}
