package ar.com.sdd.commons.util.lineparser;

import java.util.StringTokenizer;


/**
 * Parsea una linea en formato texto plano separado por comas (CSV).
 * Se puede setear un separador distinto de "," o mas de un separador,
 * por ejemplo ",|-".
 *
 * Hace falta describir los nombres de los campos.
 * Considera que todos los campos son de tipo String.
 *
 * @author Andres Ferrari.
 */
public class CSVLineParser extends LineParser {

	/**
	 * El separador por default es ','.
	 * Puedo especificar la contante TAB para indicar un \t
	 */
	protected String separators = ",";


	//---------------------------------------------------------------------------//

	/**
	 * Constructor.
	 * @param fieldNames Determina los nombres de los campos asi como su cantidad.
	 */
	public CSVLineParser(String[] fieldNames) {
		super(fieldNames);
	}


	public String getSeparators() { return separators; }
	public void setSeparators(String separators) { 
		this.separators = separators.replaceAll("TAB", "\t"); 
	}


	/**
	 * Parsea el String que representa un registro.
	 * @param lineBuffer linea de texto a parsear.
	 */
	public void parse(String lineBuffer) throws LineParserException {

		// Si la linea esta vacia, pone en null todos los valores y cancela el parseo
		if (lineBuffer == null) {
			resetFieldValues();
			return;
		}

		// OJO: necesito devolver los delimitadores para poder manejar correctamente
		// los campos nulos (quiero devolver campos nulos!)
		StringTokenizer strTokenizer = new StringTokenizer(lineBuffer, separators, true);

		String fieldValue = null;
		int i = 0;
		while (strTokenizer.hasMoreTokens()) {

			String token = strTokenizer.nextToken();

			if (i < getNumOfFields()) {

				if (separators.indexOf(token) != -1) {

					// Es un separador: pone el valor anterior como campo
					fieldValues[i] = fieldValue;
					i++;

					// Reseteo el valor de fieldValue; de esta forma si vienen
					// dos separadores seguidos, en el medio pongo un null
					fieldValue = null;

				} else {

					// Es un campo valido: lo almaceno para incluirlo cuando
					// venga el proximo separador
					// Nota: omite espacios en blanco a izquierda y derecha
					fieldValue = token.trim();

					// En el caso de que no queden mas tokens, debo incluir
					// este ultimo valor
					if (!strTokenizer.hasMoreTokens())
						fieldValues[i] = fieldValue;

				}

			} else {
                // Se ignora los campos  excedentes
                //
				//throw new LineParserException("Indice fuera de rango: " + i
				//						   + " [max = " + getNumOfFields() + "]");

			}

		}

		// Se rellena el resto con NULLs
		while ( i < getNumOfFields() ) {
			fieldValues [ i++ ] = fieldValue;
			fieldValue = null;
		}
	}

}
